/* pgmigrate-encoding: utf-8 */
alter table product_features
    alter column feature_id drop not null;

insert into product_sets (key, created_at)
values ('yandexmail', now())
on conflict (key) do nothing;


delete
from product_lines
where product_set_id = (select id from product_sets where key = 'yandexmail' limit 1);
insert into product_lines (product_set_id, created_at, order_num)
values ((select id from product_sets where key = 'yandexmail' limit 1), now(), 1);


insert into user_products
(code, title, created_at, updated_at, title_tanker_key_id, product_owner_id, available_from, billing_type,
 is_best_offer, allow_auto_prolong)
values ('b2c_mail_pro_v1', 'Почта Про', now(), now(),
        (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'products' and key = 'pochta_pro'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true),
       ('b2c_mail_disk_pro_v1', 'Почта и Диск Про', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'pochta_disk_pro'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true);


delete
from user_products_to_product_lines
where product_line_id = (select pl.id
                         from product_lines pl
                                  join product_sets ps on pl.product_set_id = ps.id
                         where ps.key = 'yandexmail'
                           and pl.order_num = 1);
insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
VALUES ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'yandexmail'
           and pl.order_num = 1),
        (select id from user_products where code = 'b2c_mail_pro_v1'),
        1),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'yandexmail'
           and pl.order_num = 1),
        (select id from user_products where code = 'b2c_mail_disk_pro_v1'),
        2);


WITH mail(host, tvm) AS (SELECT case
                                    when (select id IN ('0465e208-5abf-4b14-adb2-cb5e1ebf715e',
                                                        '77290479-7a19-4415-99cf-439783f9f9d3')
                                          from group_products
                                          where code = 'org_disk_2tb_v1')
                                        then 'settings.mail.yandex.net'
                                    else 'settings-qa.mail.yandex.net'
                                    end,
                                case
                                    when (select id IN ('0465e208-5abf-4b14-adb2-cb5e1ebf715e',
                                                        '77290479-7a19-4415-99cf-439783f9f9d3')
                                          from group_products
                                          where code = 'org_disk_2tb_v1')
                                        then 2002474
                                    else 2002242
                                    end
)
INSERT
INTO features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
               activation_url_http_method, activation_url_template, activation_body_template,
               set_amount_url_http_method, set_amount_url_template, set_amount_body_template,
               deactivation_url_http_method, deactivation_url_template, deactivation_body_template,
               call_set_amount_on_activation, call_set_amount_on_deactivation)
VALUES ('mail_pro_interface_enabled', now(), now(), (select tvm from mail), 'toggleable',
        'Включение про интерфейса в Яндекс.Почте',
        'mail',
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}',
        'has_pro_interface=on',
        NULL, NULL, NULL,
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}',
        'has_pro_interface=',
        false, false);



delete
from product_features
where user_product_id in (
    select id
    from user_products
    where code = 'b2c_mail_pro_v1'
);
insert into product_features
(user_product_id, feature_id, amount, created_at, description_tanker_key_id)
values ((select id from user_products where code = 'b2c_mail_pro_v1'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'pochta_advertise_fee')),
       ((select id from user_products where code = 'b2c_mail_pro_v1'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'priority_support')),
       ((select id from user_products where code = 'b2c_mail_pro_v1'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(), null);


delete
from product_features
where user_product_id in (
    select id
    from user_products
    where code = 'b2c_mail_disk_pro_v1'
);
insert into product_features
(user_product_id, feature_id, amount, created_at, description_tanker_key_id)
values ((select id from user_products where code = 'b2c_mail_disk_pro_v1'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'pochta_disk_advertise_fee')),
       ((select id from user_products where code = 'b2c_mail_disk_pro_v1'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'priority_support')),
       ((select id from user_products where code = 'b2c_mail_disk_pro_v1'),
        (select id from features where code = 'mpfs_disk_space'),
        107374182400, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'disk_100_gb')),
       ((select id from user_products where code = 'b2c_mail_disk_pro_v1'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'disk_pay_advantages')),
       ((select id
         from user_products
         where code = 'b2c_mail_disk_pro_v1'), (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(), null);


delete
from user_product_prices
where user_product_id in (select id from user_products where code in ('b2c_mail_disk_pro_v1', 'b2c_mail_pro_v1'));
insert into user_product_prices
    (created_at, user_product_id, region_id, price, currency, period)
VALUES (now(), (select id from user_products where code = 'b2c_mail_pro_v1'), '225', 99, 'RUB', 'month'),
       (now(), (select id from user_products where code = 'b2c_mail_pro_v1'), '225', 990, 'RUB', 'year'),
       (now(), (select id from user_products where code = 'b2c_mail_disk_pro_v1'), '225', 169, 'RUB', 'month'),
       (now(), (select id from user_products where code = 'b2c_mail_disk_pro_v1'), '225', 1690, 'RUB', 'year');
