/* pgmigrate-encoding: utf-8 */
create table refunds
(
    id               UUID      not null default uuid_generate_v4(),
    order_id         UUID      not null,
    status           text      not null,
    trust_payment_id text      not null,
    trust_refund_id  text      not null,

    created_at       timestamp not null,
    updated_at       timestamp not null,

    primary key (id),
    CONSTRAINT fk_order_id FOREIGN KEY (order_id)
        REFERENCES orders ON DELETE CASCADE
);

create index refunds_order_id_idx on refunds (order_id);
create index refunds_trust_refund_id_idx on refunds (trust_refund_id);
CREATE INDEX refunds__status_not_success__idx ON refunds (status);
CREATE INDEX orders__status_not_final__idx ON orders (status) WHERE status not in ('paid', 'error');

alter table orders
    add column subscriptions_count numeric default 0;
alter table user_products
    drop column type;
alter table user_products
    drop column period;
alter table orders
    alter column trust_amount drop NOT NULL;
alter table orders
    alter column trust_currency drop NOT NULL;

