/* pgmigrate-encoding: utf-8 */
create table trial_definitions
(
    id                   UUID      not null default uuid_generate_v4(),
    created_at           timestamp not null,
    type                 text      not null,
    end_date             timestamp null,
    duration             numeric   null,
    duration_measurement text      null,
    price                numeric   not null,
    currency             text      not null,
    hidden               boolean   not null default false,

    primary key (id)
);

alter table group_products
    add column trial_definition_id UUID null;
alter table group_products
    add constraint fk_trial_definition FOREIGN KEY (trial_definition_id) REFERENCES trial_definitions (id);
CREATE INDEX group_products_trial_definition_id_idx on group_products (trial_definition_id);

create table trial_usage
(
    id                  UUID      not null default uuid_generate_v4(),
    group_id            UUID      not null,
    group_product_id    UUID      not null,
    trial_definition_id UUID      not null,
    activated_by_uid    text      not null,
    created_at          timestamp not null,
    start_date          timestamp not null,
    end_date            timestamp null,

    primary key (id),
    CONSTRAINT fk_group FOREIGN KEY (group_id)
        REFERENCES groups ON DELETE CASCADE,
    CONSTRAINT fk_group_products FOREIGN KEY (group_product_id)
        REFERENCES group_products ON DELETE CASCADE,
    CONSTRAINT fk_trial_definition FOREIGN KEY (trial_definition_id)
        REFERENCES trial_definitions ON DELETE CASCADE
);
CREATE INDEX trial_usage_group_id_ix ON trial_usage (group_id);
CREATE INDEX trial_usage_activated_by_uid_ix ON trial_usage (activated_by_uid);
CREATE INDEX trial_usage_group_product_id_ix ON trial_usage (group_product_id);
CREATE INDEX trial_usage_trial_definition_id_ix ON trial_usage (trial_definition_id);

alter table group_products
    add COLUMN available_to timestamp null;

create table group_service_price_overrides
(
    id               UUID      not null default uuid_generate_v4(),
    group_service_id UUID      not null,
    created_at       timestamp not null,
    price            numeric   not null,
    currency         text      not null,
    start_date       timestamp not null,
    end_date         timestamp null,
    trial_usage_id   UUID      null,
    reason           text      not null,
    hidden           boolean   not null default false,
    primary key (id),
    CONSTRAINT fk_group_service FOREIGN KEY (group_service_id)
        REFERENCES group_services ON DELETE CASCADE
);
CREATE INDEX group_service_price_overrides_group_service_id_ix ON group_service_price_overrides (group_service_id);

