/* pgmigrate-encoding: utf-8 */
insert into trial_definitions
(created_at, type, end_date, duration, duration_measurement, price, hidden)
values (now(), 'constant_period', null, 30, 'day', 0, false);

update group_products
set trial_definition_id =
        (select id
         from trial_definitions
         where type = 'constant_period'
           and duration_measurement = 'day'
           and duration = 30
           and price = 0
           and hidden = false)
where code in ('org_disk_200gb_trial_v1', 'org_mail_pro_v1');



insert into trial_usage
(group_id, group_product_id, trial_definition_id, activated_by_uid, created_at, start_date, end_date)
select gs.group_id,
       gs.group_product_id,
       gp.trial_definition_id,
       g.owner_uid,
       now(),
       gs.created_at,
       '2020-09-30 21:00:00'
from group_services gs
         join group_products gp on gp.id = gs.group_product_id
         join groups g on gs.group_id = g.id
where target = 'enabled'
  and gp.code = 'org_disk_200gb_trial_v1';

insert into group_service_price_overrides
(group_service_id, created_at, price, start_date, end_date, trial_usage_id, reason, hidden)
select gs.id,
       now(),
       0,
       gs.created_at,
       '2020-09-30 21:00:00',
       u.id,
       'trial',
       false
from group_services gs
         join group_products gp on gp.id = gs.group_product_id
         join trial_usage u on u.trial_definition_id = gp.trial_definition_id
    and u.group_product_id = gs.group_product_id and u.group_id = gs.group_id
where target = 'enabled'
  and gp.code = 'org_disk_200gb_trial_v1';

update group_products
set skip_transactions_export = false
where code = 'org_disk_200gb_trial_v1';

update group_services
set skip_transactions_export = false
where exists(select 1
             from group_service_price_overrides
             where group_services.id = group_service_price_overrides.group_service_id)

















