/* pgmigrate-encoding: utf-8 */
insert into trial_definitions
(created_at, type, end_date, duration, duration_measurement, price, hidden)
values (now(), 'constant_period', null, 240, 'minute', 0, true);

update group_products
set trial_definition_id =
        (select id
         from trial_definitions
         where type = 'constant_period'
           and duration_measurement = 'minute'
           and duration = 240
           and price = 0
           and hidden = true)
where code in ('org_disk_2tb_v1');

insert into trial_usage
(group_id, group_product_id, trial_definition_id, activated_by_uid, created_at, start_date, end_date)
select gs.group_id,
       gs.group_product_id,
       gp.trial_definition_id,
       g.owner_uid,
       now(),
       gs.created_at,
       now()
from group_services gs
         join group_products gp on gp.id = gs.group_product_id
         join groups g on gs.group_id = g.id
where target = 'enabled'
  and gp.code = 'org_disk_2tb_v1';


