/* pgmigrate-encoding: utf-8 */
alter table product_owners
    add column default_group_product_id UUID null;

alter table group_products
    add column hidden boolean default false;
alter table group_services
    add column hidden boolean default false;

alter table features
    alter column system_name drop not null;

WITH mpfs(host) AS (SELECT case
                               when (select id IN ('0465e208-5abf-4b14-adb2-cb5e1ebf715e',
                                                   '6d6685f5-29ca-4b97-9268-bd21db35b0b1')
                                     from group_products
                                     where code = 'org_disk_2tb_v1')
                                   then 'mpfs.disk.yandex.net'
                               else 'mpfs-stable.dst.yandex.net'
                               end)
insert
into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
              activation_url_http_method, activation_url_template, set_amount_url_http_method,
              set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
              call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
              set_amount_body_template, deactivation_body_template, activation_content_type,
              deactivation_content_type, set_amount_content_type, error_processor_name)
values ('online_editor_disabled', now(), now(), null, 'toggleable', 'Отключание онлайн-редактора в диске',
        'mpfs', 'POST', 'https://' || (select host from mpfs) ||
                        '/json/set_ps_billing_feature?uid=#{uid}&feature_name=online_editor_enabled&value=0',
        null, null, 'POST', 'https://' || (select host from mpfs) ||
                            '/json/set_ps_billing_feature?uid=#{uid}&feature_name=online_editor_enabled&value=1',
        false, false, null, null, null, null, null, null, 'mpfs'),
       ('only_office_enabled', now(), now(), null, 'toggleable', 'Подключение ОнлиОфиса в диске',
        'mpfs', 'POST', 'https://' || (select host from mpfs) ||
                        '/json/set_ps_billing_feature?uid=#{uid}&feature_name=only_office_enabled&value=1',
        null, null, 'POST', 'https://' || (select host from mpfs) ||
                            '/json/set_ps_billing_feature?uid=#{uid}&feature_name=only_office_enabled&value=0',
        false, false, null, null, null, null, null, null, 'mpfs');

insert into user_products(code, title, created_at, updated_at, title_tanker_key_id, is_best_offer, product_owner_id,
                          available_from, billing_type, trust_subs_retry_charging_limit,
                          trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id)
values ('b2b_disk_default', 'Продукт для зарегестрированных организаций', now(), now(), null, false,
        (select id from product_owners where code = 'yandex_disk'), '2020-06-01', 'group', null, null, null, false,
        null);

insert into product_features (user_product_id, feature_id, amount, created_at, description_tanker_key_id)
values ((select id from user_products where code = 'b2b_disk_default'),
        (select id from features where code = 'online_editor_disabled'),
        1, now(), null);

insert INTO group_products(code, title, created_at, updated_at, user_product_id, balance_product_name, price,
                           currency, singleton, skip_transactions_export, trial_definition_id, available_to, hidden)
values ('org_disk_default_v1', 'Продукт для зарегестрированных организаций', now(), now(),
        (select id from user_products where code = 'b2b_disk_default'), 'disk_b2b', 0, 'RUB', true, true, null, null,
        true);

update product_owners
set default_group_product_id = (select id from group_products where code = 'org_disk_default_v1')
where code = 'yandex_disk';
