/* pgmigrate-encoding: utf-8 */
WITH mail(host, tvm) AS (SELECT case
                                    when (select id IN ('0465e208-5abf-4b14-adb2-cb5e1ebf715e',
                                                        '77290479-7a19-4415-99cf-439783f9f9d3')
                                          from group_products
                                          where code = 'org_disk_2tb_v1')
                                        then 'settings.mail.yandex.net'
                                    else 'settings-qa.mail.yandex.net'
                                    end,
                                case
                                    when (select id IN ('0465e208-5abf-4b14-adb2-cb5e1ebf715e',
                                                        '77290479-7a19-4415-99cf-439783f9f9d3')
                                          from group_products
                                          where code = 'org_disk_2tb_v1')
                                        then 2002474
                                    else 2002242
                                    end
)
INSERT
INTO features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
               activation_url_http_method, activation_url_template, activation_body_template, activation_content_type,
               set_amount_url_http_method, set_amount_url_template, set_amount_body_template, set_amount_content_type,
               deactivation_url_http_method, deactivation_url_template, deactivation_body_template, deactivation_content_type,
               call_set_amount_on_activation, call_set_amount_on_deactivation, error_processor_name
               )
VALUES ('mail_disable_mail_promo_for_trail', now(), now(), (select tvm from mail), 'toggleable', 'Отключение промо триала org_mail_pro_v1 в Яндекс.Почте', 'mail',
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}', 'is_user_b2b_mail=off', 'application/x-www-form-urlencoded',
        NULL, NULL, NULL, NULL,
        NULL, NULL, NULL, NULL,
        false, false, 'default'
        ),
       ('mail_disable_disk_promo_for_trail', now(), now(), (select tvm from mail), 'toggleable', 'Отключение промо триала org_disk_200gb_trial_v1 в Яндекс.Почте', 'mail',
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}', 'is_user_b2b_disk=off', 'application/x-www-form-urlencoded',
        NULL, NULL, NULL, NULL,
        NULL, NULL, NULL, NULL,
        false, false, 'default'
       );

-- will be inserted by script
-- INSERT INTO product_features (user_product_id, feature_id, amount, created_at)
-- VALUES ((select id from user_products where code = 'b2b_disk_200gb_v1'), (select id from features where code = 'mail_disable_disk_promo_for_trail'), 1, now()),
--        ((select id from user_products where code = 'b2b_mail_pro_v1'), (select id from features where code = 'mail_disable_mail_promo_for_trail'), 1, now());
