/* pgmigrate-encoding: utf-8 */

-- features grouping
ALTER TABLE product_features
    ADD COLUMN group_tanker_key_id UUID;
ALTER TABLE product_features
    ADD CONSTRAINT fk_group_tanker_key_id FOREIGN KEY (group_tanker_key_id) REFERENCES tanker_keys (id);
CREATE INDEX product_features_group_tanker_key_id_idx ON product_features (group_tanker_key_id);

-- title for feature values by products
ALTER TABLE product_features
    ADD COLUMN value_tanker_key_id UUID;
ALTER TABLE product_features
    ADD CONSTRAINT fk_value_tanker_key_id FOREIGN KEY (value_tanker_key_id) REFERENCES tanker_keys (id);
CREATE INDEX product_features_value_tanker_key_id_idx ON product_features (value_tanker_key_id);

-- product features order
ALTER TABLE product_features
    ADD COLUMN order_num NUMERIC NOT NULL DEFAULT 1;

-- add products, features, feature groups and feature values
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_light'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_standard100'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_premium1000'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_premium3000'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_premium5000'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_advertise_free'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_priority_support'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_unlim_mobile_video'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_ext_history'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_autosave'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_unlim_public_download'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_add_disk_space'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_smart_mail'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_group_mail_service'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_group_mail'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_group_disk'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_add_100gb'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_add_1tb'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_add_3tb'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_add_5tb'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_add_200gb'),
       (now(), 'disk-ps-billing', 'features', 'mail_pro_add_2tb');

-- product set and lines
insert into product_sets (key, created_at)
values ('mail_pro_b2c', now());

insert into product_lines (product_set_id, created_at, order_num)
values ((select id from product_sets where key = 'mail_pro_b2c' limit 1), now(), 1);

-- products
insert into user_products (code, title, created_at, updated_at,
        title_tanker_key_id,
        product_owner_id,
        available_from, billing_type, is_best_offer, allow_auto_prolong,
        trust_subs_retry_charging_limit, trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id)
values ('mail_pro_b2c_light', 'Почта Про Лайт', now(), now(),
        (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'products'
          and key = 'mail_pro_b2c_light'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true,
        '2D', '1D', '2D', true, 690),
       ('mail_pro_b2c_standard100', 'Почта Про Стандарт 100', now(), now(),
        (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'products'
          and key = 'mail_pro_b2c_standard100'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true,
        '2D', '1D', '2D', true, 690),
       ('mail_pro_b2c_premium1000', 'Почта Про Премиум 1000', now(), now(),
        (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'products'
          and key = 'mail_pro_b2c_premium1000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', true, true,
        '2D', '1D', '2D', true, 690),
       ('mail_pro_b2c_premium3000', 'Почта Про Премиум 3000', now(), now(),
        (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'products'
          and key = 'mail_pro_b2c_premium3000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true,
        '2D', '1D', '2D', true, 690),
       ('mail_pro_b2c_premium5000', 'Почта Про Премиум 5000', now(), now(),
        (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'products'
          and key = 'mail_pro_b2c_premium5000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true,
        '2D', '1D', '2D', true, 690);

insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
values ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_light'),
        1),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_standard100'),
        2),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        3),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        4),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        5);

-- features for mail
with mail (host, tvm) as (
    select
            case when
               (select id in ('0465e208-5abf-4b14-adb2-cb5e1ebf715e', '77290479-7a19-4415-99cf-439783f9f9d3')
                from group_products
                where code = 'org_disk_2tb_v1')
            then 'settings.mail.yandex.net'
            else 'settings-qa.mail.yandex.net'
            end,
            case when
                (select id in ('0465e208-5abf-4b14-adb2-cb5e1ebf715e', '77290479-7a19-4415-99cf-439783f9f9d3')
                 from group_products
                 where code = 'org_disk_2tb_v1')
            then 2002474
            else 2002242
            end
)
insert into features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
        activation_url_http_method, activation_url_template,
                      activation_body_template, activation_content_type,
        set_amount_url_http_method, set_amount_url_template,
                      set_amount_body_template, set_amount_content_type,
        deactivation_url_http_method, deactivation_url_template,
                      deactivation_body_template, deactivation_content_type,
        call_set_amount_on_activation, call_set_amount_on_deactivation, error_processor_name)
values ('mail_smart_enabled', now(), now(), (select tvm from mail), 'toggleable', 'Умная подборка писем для просмотра в первую очередь', 'mail',
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}',
        'priority_mail=on', 'application/x-www-form-urlencoded',
        null, null, null, null,
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}',
        'priority_mail=', 'application/x-www-form-urlencoded',
        false, false, 'mail');

-- advertise free for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
        description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_light'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_standard100'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- priority support for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (2, (select id from user_products where code = 'mail_pro_b2c_light'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_standard100'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- pro-interface for all products (hidden feature)
insert into product_features (user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values ((select id from user_products where code = 'mail_pro_b2c_light'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_standard100'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium1000'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium3000'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium5000'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- smart mail for all products
insert into product_features (user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values ((select id from user_products where code = 'mail_pro_b2c_light'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_standard100'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium1000'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium3000'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium5000'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null);

-- extended history for not light products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (3, (select id from user_products where code = 'mail_pro_b2c_standard100'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- unlimited mobile video for not light products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (2, (select id from user_products where code = 'mail_pro_b2c_standard100'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- autosave for not light products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (4, (select id from user_products where code = 'mail_pro_b2c_standard100'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- unlimited public download for not light products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (5, (select id from user_products where code = 'mail_pro_b2c_standard100'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- additional disk space for not light products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_standard100'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        107374182400, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_100gb')),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        1099511627776, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_1tb')),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        3298534883328, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_3tb')),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        5497558138880, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_5tb'));

-- update existing product features for values
update product_features set value_tanker_key_id = (select id
                                                   from tanker_keys
                                                   where project = 'disk-ps-billing'
                                                     and key_set = 'features'
                                                     and key = 'mail_pro_add_100gb')
where amount = 107374182400 and value_tanker_key_id is null;
update product_features set value_tanker_key_id = (select id
                                                   from tanker_keys
                                                   where project = 'disk-ps-billing'
                                                     and key_set = 'features'
                                                     and key = 'mail_pro_add_200gb')
where amount = 214748364800 and value_tanker_key_id is null;
update product_features set value_tanker_key_id = (select id
                                                   from tanker_keys
                                                   where project = 'disk-ps-billing'
                                                     and key_set = 'features'
                                                     and key = 'mail_pro_add_2tb')
where amount = 2199023255552 and value_tanker_key_id is null;

-- product prices
insert into user_product_prices (created_at, user_product_id, region_id, price, currency, period, trust_fiscal_title)
values (now(), (select id from user_products where code = 'mail_pro_b2c_light'), '10000', 79, 'RUB', 'month',
            'Почта Про Лайт на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_light'), '10000', 790, 'RUB', 'year',
            'Почта Про Лайт на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_standard100'), '10000', 139, 'RUB', 'month',
            'Почта Про Стандарт 100 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_standard100'), '10000', 1390, 'RUB', 'year',
            'Почта Про Стандарт 100 на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium1000'), '10000', 299, 'RUB', 'month',
            'Почта Про Премиум 1000 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium1000'), '10000', 2490, 'RUB', 'year',
            'Почта Про Премиум 1000 на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium3000'), '10000', 749, 'RUB', 'month',
            'Почта Про Премиум 3000 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium3000'), '10000', 7190, 'RUB', 'year',
            'Почта Про Премиум 3000 на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium5000'), '10000', 1119, 'RUB', 'month',
            'Почта Про Премиум 5000 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium5000'), '10000', 11190, 'RUB', 'year',
            'Почта Про Премиум 5000 на год');
