/* pgmigrate-encoding: utf-8 */

-- product owner
insert into product_owners(code, created_at, default_group_product_id)
values ('pro_services', now(), (select id from group_products where code = 'org_disk_default_v1'));

-- products
insert into user_products (code, title, created_at, updated_at,
                           title_tanker_key_id,
                           product_owner_id,
                           available_from, billing_type, is_best_offer, allow_auto_prolong,
                           trust_subs_retry_charging_limit, trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id)
values ('mail_pro_b2b_standard100', 'Почта Про Стандарт 100', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_standard100'),
        (select id from product_owners where code = 'pro_services'),
        null, 'group', false, false,
        null, null, null, false, null),
       ('mail_pro_b2b_premium1000', 'Почта Про Премиум 1000', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium1000'),
        (select id from product_owners where code = 'pro_services'),
        null, 'group', false, false,
        null, null, null, false, null),
       ('mail_pro_b2b_premium3000', 'Почта Про Премиум 3000', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium3000'),
        (select id from product_owners where code = 'pro_services'),
        null, 'group', false, false,
        null, null, null, false, null);

-- advertise free for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2b_standard100'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2b_premium1000'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2b_premium3000'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(), null, null, null);

-- priority support for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (2, (select id from user_products where code = 'mail_pro_b2b_standard100'),
        (select id from features where code = 'mail_priority_support'),
        1, now(), null, null, null),
       (2, (select id from user_products where code = 'mail_pro_b2b_premium1000'),
        (select id from features where code = 'mail_priority_support'),
        1, now(), null, null, null),
       (2, (select id from user_products where code = 'mail_pro_b2b_premium3000'),
        (select id from features where code = 'mail_priority_support'),
        1, now(), null, null, null);

-- pro-interface for all products (hidden feature)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (3, (select id from user_products where code = 'mail_pro_b2b_standard100'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(), null, null, null),
       (3, (select id from user_products where code = 'mail_pro_b2b_premium1000'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(), null, null, null),
       (3, (select id from user_products where code = 'mail_pro_b2b_premium3000'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(), null, null, null);

-- smart mail for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (4, (select id from user_products where code = 'mail_pro_b2b_standard100'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(), null, null, null),
       (4, (select id from user_products where code = 'mail_pro_b2b_premium1000'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(), null, null, null),
       (4, (select id from user_products where code = 'mail_pro_b2b_premium3000'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(), null, null, null);

-- additional disk space for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (5, (select id from user_products where code = 'mail_pro_b2b_standard100'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        107374182400, now(),
        null,
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_100gb')),
       (5, (select id from user_products where code = 'mail_pro_b2b_premium1000'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        1099511627776, now(),
        null,
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_1tb')),
       (5, (select id from user_products where code = 'mail_pro_b2b_premium3000'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        3298534883328, now(),
        null,
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_3tb'));

-- trial definitions
insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden)
values (now(), 'constant_period', null, 180, 'day', 0, false);

-- group products
insert into group_products (code, title, created_at, updated_at,
        user_product_id, balance_product_name, price, currency,
        singleton, skip_transactions_export,
        trial_definition_id, available_to, hidden)
values ('org_mail_pro_standard100', 'Почта Про для бизнеса: На старт', now(), now(),
        (select id from user_products where code = 'mail_pro_b2b_standard100'), 'mail_b2b', 153, 'RUB',
        true, false,
        (select id
           from trial_definitions
          where type = 'constant_period'
            and duration_measurement = 'day'
            and duration = 180
            and price = 0
            and hidden = false), null, false),
       ('org_mail_pro_premium1000', 'Почта Про для бизнеса: Внимание', now(), now(),
        (select id from user_products where code = 'mail_pro_b2b_premium1000'), 'mail_b2b', 359, 'RUB',
        true, false,
        (select id
         from trial_definitions
         where type = 'constant_period'
           and duration_measurement = 'minute'
           and duration = 240
           and price = 0
           and hidden = true), null, false),
       ('org_mail_pro_premium3000', 'Почта Про для бизнеса: Марш!', now(), now(),
        (select id from user_products where code = 'mail_pro_b2b_premium3000'), 'mail_b2b', 824, 'RUB',
        true, false,
        (select id
         from trial_definitions
         where type = 'constant_period'
           and duration_measurement = 'minute'
           and duration = 240
           and price = 0
           and hidden = true), null, false);
