/* pgmigrate-encoding: utf-8 */

-- create buckets table
create table bucket_content
(
    id                uuid      not null default uuid_generate_v4(),
    bucket_code       text      not null,
    group_product_id  uuid      not null,
    created_at        timestamp not null default now(),
    updated_at        timestamp not null,
    primary key (id),
    constraint fk_products foreign key (group_product_id)
        references group_products on delete cascade
);
create index idx_group_product_id ON bucket_content (group_product_id);
create unique index idx_bucket_code_group_product_id on bucket_content (bucket_code, group_product_id);

-- add existing buckets
insert into bucket_content (bucket_code, updated_at, group_product_id)
values ('group1', now(), (select id from group_products where code = 'org_disk_2tb_v1')),
       ('group1', now(), (select id from group_products where code = 'org_disk_200gb_trial_v1')),
       ('group1', now(), (select id from group_products where code = 'org_disk_200gb_v1')),
       ('group1', now(), (select id from group_products where code = 'org_disk_200gb_trial60_v1')),
       ('group1', now(), (select id from group_products where code = 'org_mail_pro_standard100')),
       ('group1', now(), (select id from group_products where code = 'org_mail_pro_premium3000')),
       ('group1', now(), (select id from group_products where code = 'org_mail_pro_premium1000')),
       ('group2', now(), (select id from group_products where code = 'org_mail_pro_v1')),
       ('group2', now(), (select id from group_products where code = 'org_mail_pro_trial60_v1')),
       ('group2', now(), (select id from group_products where code = 'org_mail_pro_standard100')),
       ('group2', now(), (select id from group_products where code = 'org_mail_pro_premium3000')),
       ('group2', now(), (select id from group_products where code = 'org_mail_pro_premium1000'));
