/* pgmigrate-encoding: utf-8 */

-- Add SIDs in features
with mail (host, tvm) as (
    select
        case when
                 (select id in ('0465e208-5abf-4b14-adb2-cb5e1ebf715e', '77290479-7a19-4415-99cf-439783f9f9d3')
                  from group_products
                  where code = 'org_disk_2tb_v1')
                 then 'passport-internal.yandex.ru'
             else 'passport-test-internal.yandex.ru'
            end,
        case when
                 (select id in ('0465e208-5abf-4b14-adb2-cb5e1ebf715e', '77290479-7a19-4415-99cf-439783f9f9d3')
                  from group_products
                  where code = 'org_disk_2tb_v1')
                 then 2000078
             else 2000079
            end
)
insert into features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
                      activation_url_http_method, activation_url_template,
                      activation_body_template, activation_content_type,
                      set_amount_url_http_method, set_amount_url_template,
                      set_amount_body_template, set_amount_content_type,
                      deactivation_url_http_method, deactivation_url_template,
                      deactivation_body_template, deactivation_content_type,
                      call_set_amount_on_activation, call_set_amount_on_deactivation, error_processor_name)
values ('sid_122', now(), now(), (select tvm from mail), 'toggleable', 'SID 122', 'mail',
        'POST', 'https://' || (select host from mail) || '/1/account/#{uid}/subscription/mailpro/?consumer=ps_billing',
        null, 'application/x-www-form-urlencoded',
        null, null, null, null,
        'DELETE', 'https://' || (select host from mail) || '/1/account/#{uid}/subscription/mailpro/?consumer=ps_billing',
        null, 'application/x-www-form-urlencoded',
        false, false, 'mail'),
       ('sid_123', now(), now(), (select tvm from mail), 'toggleable', 'SID 123', 'mail',
        'POST', 'https://' || (select host from mail) || '/1/account/#{uid}/subscription/mailpro_on/?consumer=ps_billing',
        null, 'application/x-www-form-urlencoded',
        null, null, null, null,
        null, null, null, null,
        false, false, 'mail');

-- SID 122 for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'b2b_mail_pro_v1'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'b2c_mail_pro_v1'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'b2c_mail_disk_pro_v1'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_light'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_standard100'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2b_standard100'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2b_premium1000'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2b_premium3000'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null);

-- SID 123 for new products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_light'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_standard100'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2b_standard100'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2b_premium1000'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2b_premium3000'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null);


