/* pgmigrate-encoding: utf-8 */

-- tanker keys
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_standard200');

-- products
insert into user_products (code, title, created_at, updated_at,
                           title_tanker_key_id,
                           product_owner_id,
                           available_from, billing_type, is_best_offer, allow_auto_prolong,
                           trust_subs_retry_charging_limit, trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id)
values ('mail_pro_b2b_standard200', 'Почта Про Стандарт 200', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_standard200'),
        (select id from product_owners where code = 'pro_services'),
        null, 'group', false, false,
        null, null, null, false, null);

-- advertise free for product
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2b_standard200'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(), null, null, null);

-- priority support for product
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (2, (select id from user_products where code = 'mail_pro_b2b_standard200'),
        (select id from features where code = 'mail_priority_support'),
        1, now(), null, null, null);

-- pro-interface for product (hidden feature)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (3, (select id from user_products where code = 'mail_pro_b2b_standard200'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(), null, null, null);

-- smart mail for product
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (4, (select id from user_products where code = 'mail_pro_b2b_standard200'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(), null, null, null);

-- additional disk space for product
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (5, (select id from user_products where code = 'mail_pro_b2b_standard200'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        214748364800, now(),
        null,
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_200gb'));

-- group product
insert into group_products (code, title, created_at, updated_at,
                            user_product_id, balance_product_name, price, currency,
                            singleton, skip_transactions_export,
                            trial_definition_id, available_to, hidden)
values ('org_mail_pro_standard200', 'Почта Про для бизнеса: На старт расширенный', now(), now(),
        (select id from user_products where code = 'mail_pro_b2b_standard200'), 'mail_b2b', 153, 'RUB',
        true, false,
        (select id
         from trial_definitions
         where type = 'constant_period'
           and duration_measurement = 'day'
           and duration = 180
           and price = 0
           and hidden = false), null, false);
