/* pgmigrate-encoding: utf-8 */
alter table product_lines
    add column selector_bean_el text null;


update product_lines
set order_num        = 3,
    selector_bean_el = 'productLineSelectorFactory.availableSelector()'
where product_set_id in (select id from product_sets s where s.key = 'mail_pro_b2c');

insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
values ((select id from product_sets where key = 'mail_pro_b2c' limit 1), now(), 1,
        'productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(5))'),
       ((select id from product_sets where key = 'mail_pro_b2c' limit 1), now(), 2,
        'productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(2))');

------------------------
-- 60days trial products
------------------------
-- products
insert into user_products (code, title, created_at, updated_at,
                           title_tanker_key_id,
                           product_owner_id,
                           available_from, billing_type, is_best_offer, allow_auto_prolong,
                           trust_subs_retry_charging_limit, trust_subs_retry_charging_delay, trust_subs_grace_period,
                           singleton, trust_service_id, trial_definition_id)
values ('mail_pro_b2c_light_60days_trial', 'Почта Про Лайт (60 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_light'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true,
        '2D', '1D', '2D', true, 690, (select id
                                      from trial_definitions
                                      where type = 'constant_period'
                                        and duration = 60
                                        and duration_measurement = 'day'
                                        and hidden = false)),
       ('mail_pro_b2c_standard100_60days_trial', 'Почта Про Стандарт 100 (60 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_standard100'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true, '2D', '1D', '2D', true, 690, (select id
                                                                          from trial_definitions
                                                                          where type = 'constant_period'
                                                                            and duration = 60
                                                                            and duration_measurement = 'day'
                                                                            and hidden = false)),
       ('mail_pro_b2c_premium1000_60days_trial', 'Почта Про Премиум 1000 (60 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium1000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', true, true, '2D', '1D', '2D', true, 690, (select id
                                                                         from trial_definitions
                                                                         where type = 'constant_period'
                                                                           and duration = 60
                                                                           and duration_measurement = 'day'
                                                                           and hidden = false)),
       ('mail_pro_b2c_premium3000_60days_trial', 'Почта Про Премиум 3000 (60 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium3000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true, '2D', '1D', '2D', true, 690, (select id
                                                                          from trial_definitions
                                                                          where type = 'constant_period'
                                                                            and duration = 60
                                                                            and duration_measurement = 'day'
                                                                            and hidden = false)),
       ('mail_pro_b2c_premium5000_60days_trial', 'Почта Про Премиум 5000 (60 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium5000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true, '2D', '1D', '2D', true, 690, (select id
                                                                          from trial_definitions
                                                                          where type = 'constant_period'
                                                                            and duration = 60
                                                                            and duration_measurement = 'day'
                                                                            and hidden = false));

insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
values ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 2),
        (select id from user_products where code = 'mail_pro_b2c_light_60days_trial'),
        1),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 2),
        (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        2),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 2),
        (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        3),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 2),
        (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        4),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 2),
        (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        5);

-- advertise free for all products (60 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_light_60days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- priority support for all products (60 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (2, (select id from user_products where code = 'mail_pro_b2c_light_60days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- pro-interface for all 60 days trial products (hidden feature)
insert into product_features (user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values ((select id from user_products where code = 'mail_pro_b2c_light_60days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- smart mail for all products (60 days trial)
insert into product_features (user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values ((select id from user_products where code = 'mail_pro_b2c_light_60days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null);

-- extended history for not light products (60 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (3, (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- unlimited mobile video for not light products (60 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (2, (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- autosave for not light products (60 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (4, (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- unlimited public download for not light products (60 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (5, (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- additional disk space for not light products (60 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        107374182400, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_100gb')),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        1099511627776, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_1tb')),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        3298534883328, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_3tb')),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        5497558138880, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_5tb'));

-- SID 122 & SID 123 for all 60 days trial products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_light_60days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_light_60days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null);


-- product prices
insert into user_product_prices (created_at, user_product_id, region_id, price, currency, period, trust_fiscal_title)
values (now(), (select id from user_products where code = 'mail_pro_b2c_light_60days_trial'), '10000', 79, 'RUB',
        'month',
        'Почта Про Лайт на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_light_60days_trial'), '10000', 790, 'RUB',
        'year',
        'Почта Про Лайт на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'), '10000', 139, 'RUB',
        'month',
        'Почта Про Стандарт 100 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_standard100_60days_trial'), '10000', 1390,
        'RUB', 'year',
        'Почта Про Стандарт 100 на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'), '10000', 299, 'RUB',
        'month',
        'Почта Про Премиум 1000 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium1000_60days_trial'), '10000', 2490,
        'RUB', 'year',
        'Почта Про Премиум 1000 на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'), '10000', 749, 'RUB',
        'month',
        'Почта Про Премиум 3000 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium3000_60days_trial'), '10000', 7190,
        'RUB', 'year',
        'Почта Про Премиум 3000 на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'), '10000', 1119,
        'RUB', 'month',
        'Почта Про Премиум 5000 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium5000_60days_trial'), '10000', 11190,
        'RUB', 'year',
        'Почта Про Премиум 5000 на год');


------------------------
-- 90days trial products
------------------------
insert into trial_definitions(created_at, type, end_date, duration, duration_measurement, price, hidden)
VALUES (now(), 'constant_period', null, 90, 'day', 0, false);

-- products
insert into user_products (code, title, created_at, updated_at,
                           title_tanker_key_id,
                           product_owner_id,
                           available_from, billing_type, is_best_offer, allow_auto_prolong,
                           trust_subs_retry_charging_limit, trust_subs_retry_charging_delay, trust_subs_grace_period,
                           singleton, trust_service_id, trial_definition_id)
values ('mail_pro_b2c_light_90days_trial', 'Почта Про Лайт (90 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_light'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true,
        '2D', '1D', '2D', true, 690, (select id
                                      from trial_definitions
                                      where type = 'constant_period'
                                        and duration = 90
                                        and duration_measurement = 'day'
                                        and hidden = false)),
       ('mail_pro_b2c_standard100_90days_trial', 'Почта Про Стандарт 100 (90 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_standard100'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true, '2D', '1D', '2D', true, 690, (select id
                                                                          from trial_definitions
                                                                          where type = 'constant_period'
                                                                            and duration = 90
                                                                            and duration_measurement = 'day'
                                                                            and hidden = false)),
       ('mail_pro_b2c_premium1000_90days_trial', 'Почта Про Премиум 1000 (90 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium1000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', true, true, '2D', '1D', '2D', true, 690, (select id
                                                                         from trial_definitions
                                                                         where type = 'constant_period'
                                                                           and duration = 90
                                                                           and duration_measurement = 'day'
                                                                           and hidden = false)),
       ('mail_pro_b2c_premium3000_90days_trial', 'Почта Про Премиум 3000 (90 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium3000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true, '2D', '1D', '2D', true, 690, (select id
                                                                          from trial_definitions
                                                                          where type = 'constant_period'
                                                                            and duration = 90
                                                                            and duration_measurement = 'day'
                                                                            and hidden = false)),
       ('mail_pro_b2c_premium5000_90days_trial', 'Почта Про Премиум 5000 (90 дней триал)', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium5000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true, '2D', '1D', '2D', true, 690, (select id
                                                                          from trial_definitions
                                                                          where type = 'constant_period'
                                                                            and duration = 90
                                                                            and duration_measurement = 'day'
                                                                            and hidden = false));

insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
values ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_light_90days_trial'),
        1),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        2),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        3),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        4),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and pl.order_num = 1),
        (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        5);

-- advertise free for all products (90 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_light_90days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- priority support for all products (90 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (2, (select id from user_products where code = 'mail_pro_b2c_light_90days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- pro-interface for all 90 days trial products (hidden feature)
insert into product_features (user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values ((select id from user_products where code = 'mail_pro_b2c_light_90days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- smart mail for all products (90 days trial)
insert into product_features (user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values ((select id from user_products where code = 'mail_pro_b2c_light_90days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       ((select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null);

-- extended history for not light products (90 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (3, (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- unlimited mobile video for not light products (90 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (2, (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- autosave for not light products (90 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (4, (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- unlimited public download for not light products (90 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (5, (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- additional disk space for not light products (90 days trial)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        107374182400, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_100gb')),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        1099511627776, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_1tb')),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        3298534883328, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_3tb')),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        5497558138880, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_5tb'));

-- SID 122 & SID 123 for all 90 days trial products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_light_90days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_light_90days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null);


-- product prices
insert into user_product_prices (created_at, user_product_id, region_id, price, currency, period, trust_fiscal_title)
values (now(), (select id from user_products where code = 'mail_pro_b2c_light_90days_trial'), '10000', 79, 'RUB',
        'month',
        'Почта Про Лайт на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_light_90days_trial'), '10000', 790, 'RUB',
        'year',
        'Почта Про Лайт на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'), '10000', 139, 'RUB',
        'month',
        'Почта Про Стандарт 100 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_standard100_90days_trial'), '10000', 1390,
        'RUB', 'year',
        'Почта Про Стандарт 100 на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'), '10000', 299, 'RUB',
        'month',
        'Почта Про Премиум 1000 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium1000_90days_trial'), '10000', 2490,
        'RUB', 'year',
        'Почта Про Премиум 1000 на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'), '10000', 749, 'RUB',
        'month',
        'Почта Про Премиум 3000 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium3000_90days_trial'), '10000', 7190,
        'RUB', 'year',
        'Почта Про Премиум 3000 на год'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'), '10000', 1119,
        'RUB', 'month',
        'Почта Про Премиум 5000 на месяц'),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium5000_90days_trial'), '10000', 11190,
        'RUB', 'year',
        'Почта Про Премиум 5000 на год');




