/* pgmigrate-encoding: utf-8 */

-- add standard200 product into buckets
insert into bucket_content (bucket_code, updated_at, group_product_id)
values ('group1', now(), (select id from group_products where code = 'org_mail_pro_standard200')),
       ('group2', now(), (select id from group_products where code = 'org_mail_pro_standard200'));

-- rename group products
update public.group_products
    set title = 'Базовый'
    where code = 'org_mail_pro_standard100';
update public.group_products
    set title = 'Базовый+'
    where code = 'org_mail_pro_standard200';
update public.group_products
    set title = 'Стандартный'
    where code = 'org_mail_pro_premium1000';
update public.group_products
    set title = 'Профессиональный'
    where code = 'org_mail_pro_premium3000';

-- enable features for new b2c and b2b products
update public.product_features
    set enabled = true
    where id in (
        select pf.id
        from product_features pf
                 join user_products up on pf.user_product_id = up.id
                 join features f on pf.feature_id = f.id
        where f.code = 'sid_122' and pf.enabled = false and up.code like 'mail_pro_b2%'
        );

-- add tanker keys
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'products', 'mail_pro_b2b_standard100'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2b_standard200'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2b_premium1000'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2b_premium3000');

-- rename b2b user products
update public.user_products
    set title = 'Базовый', title_tanker_key_id = (select id
                                                  from tanker_keys
                                                  where project = 'disk-ps-billing'
                                                    and key_set = 'products'
                                                    and key = 'mail_pro_b2b_standard100')
    where code = 'mail_pro_b2b_standard100';
update public.user_products
set title = 'Базовый+', title_tanker_key_id = (select id
                                              from tanker_keys
                                              where project = 'disk-ps-billing'
                                                and key_set = 'products'
                                                and key = 'mail_pro_b2b_standard200')
where code = 'mail_pro_b2b_standard200';
update public.user_products
set title = 'Стандартный', title_tanker_key_id = (select id
                                              from tanker_keys
                                              where project = 'disk-ps-billing'
                                                and key_set = 'products'
                                                and key = 'mail_pro_b2b_premium1000')
where code = 'mail_pro_b2b_premium1000';
update public.user_products
set title = 'Профессиональный', title_tanker_key_id = (select id
                                              from tanker_keys
                                              where project = 'disk-ps-billing'
                                                and key_set = 'products'
                                                and key = 'mail_pro_b2b_premium3000')
where code = 'mail_pro_b2b_premium3000';
