/* pgmigrate-encoding: utf-8 */

-- defining uniq trials for each group_product
with def as (
    insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden)
        values (now(), 'constant_period', null, 180, 'day', 0, false)
        returning *
)
update group_products
set trial_definition_id = (select id from def)
where code = 'org_mail_pro_standard100';

with def as (
    insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden)
        values (now(), 'constant_period', null, 240, 'minute', 0, true)
        returning *
)
update group_products
set trial_definition_id = (select id from def)
where code = 'org_mail_pro_premium3000';

with def as (
    insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden)
        values (now(), 'constant_period', null, 240, 'minute', 0, true)
        returning *
)
update group_products
set trial_definition_id = (select id from def)
where code = 'org_mail_pro_premium1000';

with def as (
    insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden)
        values (now(), 'constant_period', null, 30, 'day', 0, false)
        returning *
)
update group_products
set trial_definition_id = (select id from def)
where code = 'org_mail_pro_v1';

with def as (
    insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden)
        values (now(), 'constant_period', null, 60, 'day', 0, false)
        returning *
)
update group_products
set trial_definition_id = (select id from def)
where code = 'org_mail_pro_trial60_v1';

update trial_usage as u
set trial_definition_id = (select trial_definition_id from group_products g where g.id = u.group_product_id);

alter table trial_usage
    alter column group_product_id drop NOT NULL;
alter table trial_usage
    alter column group_id drop NOT NULL;

alter table trial_definitions
    add column single_usage_comparison_key text null;
update trial_definitions
set single_usage_comparison_key = uuid_generate_v4();
alter table trial_definitions
    alter column single_usage_comparison_key set not null;

CREATE INDEX trial_definitions__single_usage_comparison_key__idx on trial_definitions (single_usage_comparison_key);


-- make trial definition for new mail_pro_b2c_ products
with def as (
    insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                   single_usage_comparison_key)
        values (now(), 'constant_period', null, 30, 'day', 0, false, uuid_generate_v4())
        returning *
)
update group_products
set trial_definition_id = (select id from def)
where code like 'mail_pro_b2c_%_30days_trial';

with def as (
    insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                   single_usage_comparison_key)
        values (now(), 'constant_period', null, 60, 'day', 0, false, uuid_generate_v4())
        returning *
)
update group_products
set trial_definition_id = (select id from def)
where code like 'mail_pro_b2c_%_60days_trial';

update trial_definitions
set single_usage_comparison_key = 'mail_pro_b2c_trial_key'
where id in (select trial_definition_id
             from user_products
             where code like 'mail_pro_b2c_%'
               and trial_definition_id is not null);


update product_lines
set selector_bean_el = 'productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(5)))'
where product_set_id = (select id from product_sets where key = 'mail_pro_b2c' limit 1)
  and order_num = 1;

update product_lines
set selector_bean_el = 'productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(2)))'
where product_set_id = (select id from product_sets where key = 'mail_pro_b2c' limit 1)
  and order_num = 2;

update product_lines
set selector_bean_el = 'productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.availableSelector())'
where product_set_id = (select id from product_sets where key = 'mail_pro_b2c' limit 1)
  and order_num = 3;


alter table group_products
    alter column title drop not null;
alter table user_products
    drop column title;
