/* pgmigrate-encoding: utf-8 */
insert into features
(code, created_at, updated_at, system_tvm_id, type, description, system_name, activation_url_http_method,
 activation_url_template, set_amount_url_http_method, set_amount_url_template, deactivation_url_http_method,
 deactivation_url_template, call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
 set_amount_body_template, deactivation_body_template, activation_content_type, deactivation_content_type,
 set_amount_content_type, error_processor_name)
select 'mpfs_disk_space_for_b2b_mail_360',
       now(),
       now(),
       system_tvm_id,
       type,
       'Предоставление места в Яндекс.Диске с названием сервиса под почту 360 для бизнеса, измеряется в байтах',
       system_name,
       activation_url_http_method,
       replace(activation_url_template, 'yandex_mail_pro', 'yandex_b2b_mail_pro'),
       set_amount_url_http_method,
       set_amount_url_template,
       deactivation_url_http_method,
       deactivation_url_template,
       call_set_amount_on_activation,
       call_set_amount_on_deactivation,
       activation_body_template,
       set_amount_body_template,
       deactivation_body_template,
       activation_content_type,
       deactivation_content_type,
       set_amount_content_type,
       error_processor_name
from features
where code = 'mpfs_disk_space_for_mail_pro';


insert into product_features (user_product_id, feature_id, amount, created_at, description_tanker_key_id,
                              group_tanker_key_id, value_tanker_key_id, enabled, order_num)
select pf.user_product_id,
       (select id from features where code = 'mpfs_disk_space_for_b2b_mail_360' limit 1),
       pf.amount,
       now(),
       pf.description_tanker_key_id,
       pf.group_tanker_key_id,
       pf.value_tanker_key_id,
       true,
       pf.order_num
from product_features pf
         join user_products up on pf.user_product_id = up.id
where pf.feature_id in (select id from features where code = 'mpfs_disk_space_for_mail_pro')
  and up.code like 'mail_pro_b2b%';

update product_features
set enabled = false
where id in (
    select pf.id
    from product_features pf
             join user_products up on pf.user_product_id = up.id
    where pf.feature_id in (select id from features where code = 'mpfs_disk_space_for_mail_pro')
      and up.code like 'mail_pro_b2b%');


