/* pgmigrate-encoding: utf-8 */

update user_products as t1
set title_tanker_key_id =
        (select title_tanker_key_id from user_products t2 where t2.code = 'mail_pro_b2c_premium1000')
where t1.code = 'b2c_mail_pro_free_v1';

-- enable sid_122
update public.product_features
set enabled = true
where id in (
    select pf.id
    from product_features pf
             join features f on pf.feature_id = f.id
             join user_products up on pf.user_product_id = up.id
    where f.code = 'sid_122' and pf.enabled = false and up.code in ('b2c_mail_disk_pro_v1', 'b2c_mail_pro_v1', 'b2b_mail_pro_v1', 'b2c_mail_pro_free_v1')
);

-- additional disk space
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (6, (select id from user_products where code = 'b2c_mail_pro_free_v1'),
        (select id from features where code = 'mpfs_disk_space_for_mail_pro'),
        1099511627776, now(),
        null,
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_1tb'));
