/* pgmigrate-encoding: utf-8 */

insert into group_services (group_id, group_product_id, deduplication_key, b_date, created_at, target,
                            target_updated_at, status, status_updated_at, actual_enabled_at, actual_disabled_at,
                            skip_transactions_export, hidden)


select aa.group_id,
       gp.id,
       null,
       now(),
       now(),
       'enabled',
       now(),
       'init',
       now(),
       null,
       null,
       gp.skip_transactions_export,
       gp.hidden
from accepted_agreements aa
         join product_owners po
              on aa.product_owner_id = po.id
         join group_products gp on po.default_group_product_id = gp.id
where not exists(select 1
                 from group_services gs
                 where gs.group_id = aa.group_id
                   and gs.group_product_id = po.default_group_product_id);




