/* pgmigrate-encoding: utf-8 */

with mpfs(host) as (select case
                               when (select id IN ('0465e208-5abf-4b14-adb2-cb5e1ebf715e',
                                                   '6d6685f5-29ca-4b97-9268-bd21db35b0b1')
                                     from group_products
                                     where code = 'org_disk_2tb_v1')
                                   then 'mpfs.disk.yandex.net'
                               else 'mpfs-stable.dst.yandex.net'
                               end)
insert into features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
                      activation_url_http_method, activation_url_template,
                      activation_body_template, activation_content_type,
                      set_amount_url_http_method, set_amount_url_template,
                      set_amount_body_template, set_amount_content_type,
                      deactivation_url_http_method, deactivation_url_template,
                      deactivation_body_template, deactivation_content_type,
                      call_set_amount_on_activation, call_set_amount_on_deactivation, error_processor_name)
values ('mpfs_advertising_disabled', now(), now(), null, 'toggleable', 'Отключение рекламы в Яндекс.Диске', 'mpfs',
        'POST', 'https://' || (select host from mpfs) || '/json/set_ps_billing_feature?uid=#{uid}&feature_name=advertising_enabled&value=0',
        null, null, null, null, null, null,
        'POST', 'https://' || (select host from mpfs) || '/json/set_ps_billing_feature?uid=#{uid}&feature_name=advertising_enabled&value=1',
        null, null, false, false, 'mpfs_with_skip_not_initialized');

update features set error_processor_name = 'mpfs_with_skip_not_initialized'
where code in ('online_editor_disabled', 'only_office_enabled');

update product_features
set feature_id = (select id from features where code = 'mpfs_advertising_disabled')
where user_product_id in (select id from user_products where code in (
    'mail_pro_b2c_light', 'mail_pro_b2c_light_30days_trial_v2',
    'mail_pro_b2c_light_60days_trial_v2', 'mail_pro_b2c_light_90days_trial_v2'))
  and description_tanker_key_id = (select id from tanker_keys
        where key = 'mail_pro_b2c_advertise_free' and project = 'disk-ps-billing' and key_set = 'features');
