/* pgmigrate-encoding: utf-8 */

-- add tanker keys
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'products', 'mail_pro_b2b_edu_standard100'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2b_edu_premium1000'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2b_edu_premium3000');

-- products
insert into user_products (code, created_at, updated_at,
                           title_tanker_key_id,
                           product_owner_id,
                           available_from, billing_type, is_best_offer, allow_auto_prolong,
                           trust_subs_retry_charging_limit, trust_subs_retry_charging_delay, trust_subs_grace_period,
                           singleton, trust_service_id, trial_definition_id)
values ('mail_pro_b2b_edu_standard100', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2b_edu_standard100'),
        (select id from product_owners where code = 'yandex_mail'),
        null, 'group', false, false,
        null, null, null,
        false, null, null),
       ('mail_pro_b2b_edu_premium1000', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2b_edu_premium1000'),
        (select id from product_owners where code = 'yandex_mail'),
        null, 'group', false, false,
        null, null, null,
        false, null, null),
       ('mail_pro_b2b_edu_premium3000', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2b_edu_premium3000'),
        (select id from product_owners where code = 'yandex_mail'),
        null, 'group', false, false,
        null, null, null,
        false, null, null);

-- advertise free for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled)
values (1, (select id from user_products where code = 'mail_pro_b2b_edu_standard100'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(), null, null, null, true),
       (1, (select id from user_products where code = 'mail_pro_b2b_edu_premium1000'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(), null, null, null, true),
       (1, (select id from user_products where code = 'mail_pro_b2b_edu_premium3000'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(), null, null, null, true);

-- SID 122 for edu products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled)
values (1, (select id from user_products where code = 'mail_pro_b2b_edu_standard100'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null, true),
       (1, (select id from user_products where code = 'mail_pro_b2b_edu_premium1000'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null, true),
       (1, (select id from user_products where code = 'mail_pro_b2b_edu_premium3000'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null, true);

-- SID 123 for edu products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled)
values (1, (select id from user_products where code = 'mail_pro_b2b_edu_standard100'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null, true),
       (1, (select id from user_products where code = 'mail_pro_b2b_edu_premium1000'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null, true),
       (1, (select id from user_products where code = 'mail_pro_b2b_edu_premium3000'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null, true);

-- priority support for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled)
values (2, (select id from user_products where code = 'mail_pro_b2b_edu_standard100'),
        (select id from features where code = 'mail_priority_support'),
        1, now(), null, null, null, true),
       (2, (select id from user_products where code = 'mail_pro_b2b_edu_premium1000'),
        (select id from features where code = 'mail_priority_support'),
        1, now(), null, null, null, true),
       (2, (select id from user_products where code = 'mail_pro_b2b_edu_premium3000'),
        (select id from features where code = 'mail_priority_support'),
        1, now(), null, null, null, true);

-- pro-interface for all products (hidden feature)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled)
values (3, (select id from user_products where code = 'mail_pro_b2b_edu_standard100'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(), null, null, null, true),
       (3, (select id from user_products where code = 'mail_pro_b2b_edu_premium1000'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(), null, null, null, true),
       (3, (select id from user_products where code = 'mail_pro_b2b_edu_premium3000'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(), null, null, null, true);

-- smart mail for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled)
values (4, (select id from user_products where code = 'mail_pro_b2b_edu_standard100'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(), null, null, null, true),
       (4, (select id from user_products where code = 'mail_pro_b2b_edu_premium1000'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(), null, null, null, true),
       (4, (select id from user_products where code = 'mail_pro_b2b_edu_premium3000'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(), null, null, null, true);

-- additional disk space for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled)
values (5, (select id from user_products where code = 'mail_pro_b2b_edu_standard100'),
        (select id from features where code = 'mpfs_disk_space_for_b2b_mail_360'),
        107374182400, now(),
        null,
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_100gb'),
        true),
       (5, (select id from user_products where code = 'mail_pro_b2b_edu_premium1000'),
        (select id from features where code = 'mpfs_disk_space_for_b2b_mail_360'),
        1099511627776, now(),
        null,
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_1tb'),
        true),
       (5, (select id from user_products where code = 'mail_pro_b2b_edu_premium3000'),
        (select id from features where code = 'mpfs_disk_space_for_b2b_mail_360'),
        3298534883328, now(),
        null,
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_3tb'),
        true);

-- add only office
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled)
values (999, (select id from user_products where code = 'mail_pro_b2b_edu_standard100'),
        (select id from features where code = 'only_office_enabled'),
        1, now(), null, null, null, true),
       (999, (select id from user_products where code = 'mail_pro_b2b_edu_premium1000'),
        (select id from features where code = 'only_office_enabled'),
        1, now(), null, null, null, true),
       (999, (select id from user_products where code = 'mail_pro_b2b_edu_premium3000'),
        (select id from features where code = 'only_office_enabled'),
        1, now(), null, null, null, true);

-- add trial_definitions
insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden, single_usage_comparison_key)
values (now(), 'constant_period', null, 180, 'day', 0, false, 'mail_pro_b2b_edu_standard100');
insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden, single_usage_comparison_key)
values (now(), 'constant_period', null, 240, 'minute', 0, true, 'mail_pro_b2b_edu_premium1000');
insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden, single_usage_comparison_key)
values (now(), 'constant_period', null, 240, 'minute', 0, true, 'mail_pro_b2b_edu_premium3000');

-- group products
insert into group_products (code, created_at, updated_at,
        user_product_id, balance_product_name, price, currency,
        singleton, skip_transactions_export,
        trial_definition_id, available_to, hidden, title_tanker_key_id)
values ('org_mail_pro_edu_standard100', now(), now(),
        (select id from user_products where code = 'mail_pro_b2b_edu_standard100'), 'mail_b2b', 76.5, 'RUB',
        true, false,
        (select id
           from trial_definitions
          where type = 'constant_period'
            and duration_measurement = 'day'
            and duration = 180
            and price = 0
            and single_usage_comparison_key = 'mail_pro_b2b_edu_standard100'
            and hidden = false), null, false,
        (select id
            from tanker_keys
          where project = 'disk-ps-billing'
            and key_set = 'products'
            and key = 'mail_pro_b2b_edu_standard100')),
       ('org_mail_pro_edu_premium1000', now(), now(),
        (select id from user_products where code = 'mail_pro_b2b_edu_premium1000'), 'mail_b2b', 155.5, 'RUB',
        true, false,
        (select id
         from trial_definitions
         where type = 'constant_period'
           and duration_measurement = 'minute'
           and duration = 240
           and price = 0
           and single_usage_comparison_key = 'mail_pro_b2b_edu_premium1000'
           and hidden = true), null, false,
        (select id
            from tanker_keys
          where project = 'disk-ps-billing'
            and key_set = 'products'
            and key = 'mail_pro_b2b_edu_premium1000')),
       ('org_mail_pro_edu_premium3000', now(), now(),
        (select id from user_products where code = 'mail_pro_b2b_edu_premium3000'), 'mail_b2b', 412, 'RUB',
        true, false,
        (select id
         from trial_definitions
         where type = 'constant_period'
           and duration_measurement = 'minute'
           and duration = 240
           and price = 0
           and single_usage_comparison_key = 'mail_pro_b2b_edu_premium3000'
           and hidden = true), null, false,
        (select id
            from tanker_keys
          where project = 'disk-ps-billing'
            and key_set = 'products'
            and key = 'mail_pro_b2b_edu_premium3000'));

-- add existing buckets
insert into bucket_content (bucket_code, updated_at, group_product_id)
values ('group1', now(), (select id from group_products where code = 'org_mail_pro_edu_standard100')),
       ('group1', now(), (select id from group_products where code = 'org_mail_pro_edu_premium3000')),
       ('group1', now(), (select id from group_products where code = 'org_mail_pro_edu_premium1000')),
       ('group2', now(), (select id from group_products where code = 'org_mail_pro_edu_standard100')),
       ('group2', now(), (select id from group_products where code = 'org_mail_pro_edu_premium3000')),
       ('group2', now(), (select id from group_products where code = 'org_mail_pro_edu_premium1000'));
