create table group_products_to_product_lines
(
    product_line_id  uuid    not null,
    group_product_id uuid    not null,
    order_num        numeric not null,
    is_best_offer    boolean default false not null,

    PRIMARY KEY (product_line_id, group_product_id),
    CONSTRAINT fk_product_line FOREIGN KEY (product_line_id)
        REFERENCES product_lines ON DELETE CASCADE,

    CONSTRAINT fk_group_product FOREIGN KEY (group_product_id)
        REFERENCES group_products ON DELETE CASCADE
);
CREATE INDEX group_products_to_product_lines_group_product_id_ix ON group_products_to_product_lines (group_product_id);
