alter table group_products
    add column is_best_offer boolean default false NOT NULL;

insert into product_sets (key, created_at)
values ('mail_pro_b2b', now());

-- product lines
insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
values ((select id from product_sets where key = 'mail_pro_b2b' limit 1), now(), 2,
        'productLineSelectorFactory.availableSelector()');

insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
values ((select id from product_sets where key = 'mail_pro_b2b' limit 1), now(), 1,
        'productLineSelectorFactory.educationalGroupProductSelector()');

-- insert mapping for default group product line
insert into group_products_to_product_lines (product_line_id, group_product_id, order_num)
values ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2b'
           and pl.order_num = 2),
        (select id from group_products where code = 'org_mail_pro_standard100'),
        1),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2b'
           and pl.order_num = 2),
        (select id from group_products where code = 'org_mail_pro_premium1000'),
        2),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2b'
           and pl.order_num = 2),
        (select id from group_products where code = 'org_mail_pro_premium3000'),
        3);

-- insert mapping for educational group product line
insert into group_products_to_product_lines (product_line_id, group_product_id, order_num)
values ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2b'
           and pl.order_num = 1),
        (select id from group_products where code = 'org_mail_pro_edu_standard100'),
        1),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2b'
           and pl.order_num = 1),
        (select id from group_products where code = 'org_mail_pro_edu_premium1000'),
        2),
       ((select pl.id
         from product_lines pl
                  join product_sets ps on pl.product_set_id = ps.id
         where ps.key = 'mail_pro_b2b'
           and pl.order_num = 1),
        (select id from group_products where code = 'org_mail_pro_edu_premium3000'),
        3);


update group_products
set is_best_offer = true where code in ('org_mail_pro_edu_standard100', 'org_mail_pro_standard100');
