/* pgmigrate-encoding: utf-8 */

with orgs as (
    select *
    from groups
    where group_type = 'organization'
      and group_external_id in (
                                '3953953', '11427', '62361', '120765', '669235', '912516', '3148250', '1248243',
                                '4067004', '392177', '61077', '2295799', '3919881', '82511', '3655221', '3953051',
                                '41494', '1982828', '279507', '793192', '3953681', '647959', '3961492', '3962924',
                                '3885562', '3927481', '3953535', '2758405', '738667', '1737680', '386951', '5218499',
                                '3191436', '2279439', '2279246', '512194', '510520', '3150013', '4071796', '669235',
                                '2499784', '3914976', '65435', '3972984', '2120982', '3204480', '3356881', '3214019',
                                '3941960', '2414592', '3956082', '3981095', '661358', '3955190', '5612432', '3944088',
                                '3788791', '818411', '2279719', '1389183', '1192755', '3968716', '3974974', '3938080')
),
     gr_serv as (
         select *
         from group_services
         where group_id in (select id from orgs)
           and group_product_id in (select id from group_products where code = 'org_disk_200gb_trial_v1')
           and actual_disabled_at > '2020-11-01'
     ),
     ins_overrides as (insert into group_service_price_overrides
         (group_service_id, created_at, price, start_date, end_date, trial_usage_id, reason)
         select t.id, now(), 0, '2020-11-01', t.actual_disabled_at, null, 'gift' from gr_serv t)

delete
from group_service_transactions
where group_service_id in (select id from gr_serv)
  and billing_date >= '2020-11-01'

