/* pgmigrate-encoding: utf-8 */

-- products
insert into user_products (code, created_at, updated_at,
                           title_tanker_key_id,
                           product_owner_id,
                           available_from, billing_type, is_best_offer, allow_auto_prolong,
                           trust_subs_retry_charging_limit, trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id)
values ('mail_pro_b2c_standard100_new_year_2021', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_standard100'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true,
        '2D', '1D', '2D', true, 690),
       ('mail_pro_b2c_premium1000_new_year_2021', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium1000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', true, true,
        '2D', '1D', '2D', true, 690),
       ('mail_pro_b2c_premium3000_new_year_2021', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium3000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true,
        '2D', '1D', '2D', true, 690),
       ('mail_pro_b2c_premium5000_new_year_2021', now(), now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'products'
           and key = 'mail_pro_b2c_premium5000'),
        (select id from product_owners where code = 'yandex_mail'),
        current_date, 'trust', false, true,
        '2D', '1D', '2D', true, 690);


-- priority support for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (1, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (1, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        (select id from features where code = 'mail_priority_support'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_priority_support'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- advertise free for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (2, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (2, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        (select id from features where code = 'mail_ad_disabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_advertise_free'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- smart mail for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (3, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null),
       (3, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        (select id from features where code = 'mail_smart_enabled'),
        1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_smart_mail'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail'),
        null);

-- additional disk space
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (4, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        (select id from features where code = 'mpfs_disk_space_for_mail_360'),
        107374182400, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_100gb')),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        (select id from features where code = 'mpfs_disk_space_for_mail_360'),
        1099511627776, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_1tb')),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        (select id from features where code = 'mpfs_disk_space_for_mail_360'),
        3298534883328, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_3tb')),
       (4, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        (select id from features where code = 'mpfs_disk_space_for_mail_360'),
        5497558138880, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_add_disk_space'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_add_5tb'));

-- unlimited mobile video
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (5, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (5, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_mobile_video'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- extended history
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (6, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (6, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (6, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (6, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_ext_history'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- autosave
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (7, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (7, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (7, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (7, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_autosave'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- unlimited public download
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (8, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (8, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (8, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null),
       (8, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        null, 1, now(),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_unlim_public_download'),
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_disk'),
        null);

-- pro-interface (hidden feature)
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (999, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (999, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (999, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null),
       (999, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        (select id from features where code = 'mail_pro_interface_enabled'),
        1, now(),
        null,
        (select id
         from tanker_keys
         where project = 'disk-ps-billing'
           and key_set = 'features'
           and key = 'mail_pro_b2c_group_mail_service'),
        null);

-- SID 122
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (999, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (999, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (999, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null),
       (999, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        (select id from features where code = 'sid_122'),
        1, now(), null, null, null);

-- SID 123
insert into product_features (order_num, user_product_id, feature_id, amount, created_at,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id)
values (999, (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (999, (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (999, (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null),
       (999, (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'),
        (select id from features where code = 'sid_123'),
        1, now(), null, null, null);


-- product prices
insert into user_product_prices (created_at, user_product_id, region_id, price, currency, period, trust_fiscal_title,
                                 display_discount_percent, display_original_price)
values (now(), (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'), '10000', 111, 'RUB', 'month',
        'Почта 360 Стандарт 100 на месяц (скидка -20%)', 20, 139),
       (now(), (select id from user_products where code = 'mail_pro_b2c_standard100_new_year_2021'), '10000', 1112, 'RUB', 'year',
        'Почта 360 Стандарт 100 на год (скидка -20%)', 20, 1390),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'), '10000', 239, 'RUB', 'month',
        'Почта 360 Премиум 1000 на месяц (скидка -20%)', 20, 299),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium1000_new_year_2021'), '10000', 1992, 'RUB', 'year',
        'Почта 360 Премиум 1000 на год (скидка -20%)', 20, 2490),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'), '10000', 599, 'RUB', 'month',
        'Почта 360 Премиум 3000 на месяц (скидка -20%)', 20, 749),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium3000_new_year_2021'), '10000', 5752 , 'RUB', 'year',
        'Почта 360 Премиум 3000 на год (скидка -20%)', 20, 7190),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'), '10000', 895, 'RUB', 'month',
        'Почта 360 Премиум 5000 на месяц (скидка -20%)', 20, 1119),
       (now(), (select id from user_products where code = 'mail_pro_b2c_premium5000_new_year_2021'), '10000', 8952, 'RUB', 'year',
        'Почта 360 Премиум 5000 на год (скидка -20%)', 20, 11190);
