create table user_product_periods
(
    id                 UUID      NOT NULL DEFAULT uuid_generate_v4(),
    user_product_id    UUID      NOT NULL,
    period             text      NOT NULL,
    code               text      null,
    trust_fiscal_title text      null,
    created_at         timestamp not null,

    PRIMARY KEY (id),
    CONSTRAINT fk_user_product FOREIGN KEY (user_product_id)
        REFERENCES user_products
);

CREATE UNIQUE INDEX user_product_period_code_ix ON user_product_periods (code);
CREATE UNIQUE INDEX user_product_period_product_code_ix ON user_product_periods (user_product_id, period);


insert into user_product_periods(user_product_id, period, code, trust_fiscal_title, created_at)
select user_product_id, period, 'PS_BILLING_' || up.code || '_' || upp.period || '_' || 'subs', trust_fiscal_title, now()
from user_product_prices upp
         join user_products up on up.id = upp.user_product_id;

alter table user_product_prices
    add column user_product_period_id UUID null;

update user_product_prices pr
set user_product_period_id =
        (select id
         from user_product_periods per
         where per.user_product_id = pr.user_product_id
           and per.period = pr.period);

alter table user_product_prices
    alter column user_product_period_id set not null;
alter table user_product_prices
    alter column user_product_id drop not null;
alter table user_product_prices
    alter column period drop not null;
