create table group_trust_payment_requests
(
    id               uuid      not null   default uuid_generate_v4(),
    created_at       timestamp not null,
    request_id       text      not null,
    group_id         uuid      not null,
    status           text      not null,

    PRIMARY KEY (id),
    CONSTRAINT fk_groups FOREIGN KEY (group_id)
        REFERENCES groups ON DELETE RESTRICT
);
CREATE UNIQUE INDEX group_trust_payment_requests_request_id_uk ON group_trust_payment_requests (request_id);

CREATE INDEX group_trust_payment_requests_group_id_idx ON group_trust_payment_requests (group_id);

CREATE INDEX group_trust_payment_requests_status_created_at_idx ON group_trust_payment_requests (status, created_at);

