/* pgmigrate-encoding: utf-8 */
/* pgmigrate-encoding: utf-8 */
insert into tanker_keys(created_at, project, key_set, key)
VALUES (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_light_android'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_light_ios');


INSERT INTO user_products (code, created_at, updated_at, title_tanker_key_id, is_best_offer,
                           product_owner_id, available_from, billing_type, allow_auto_prolong,
                           trust_subs_retry_charging_limit, trust_subs_retry_charging_delay,
                           trust_subs_grace_period, singleton, trust_service_id, trial_definition_id)
VALUES ('mail_pro_b2c_light_inapp_google', now(), now(), (select id
                                                          from tanker_keys
                                                          where project = 'disk-ps-billing'
                                                            and key_set = 'products'
                                                            and key = 'mail_pro_b2c_light_android'), false,
        (select id from product_owners where code = 'yandex_mail'), null, 'inapp_google', true, null, null, null, true,
        116, null),
       ('mail_pro_b2c_light_inapp_apple', now(), now(), (select id
                                                         from tanker_keys
                                                         where project = 'disk-ps-billing'
                                                           and key_set = 'products'
                                                           and key = 'mail_pro_b2c_light_ios'), false,
        (select id from product_owners where code = 'yandex_mail'), null, 'inapp_apple', true, null,
        null, null, true, 116, null);

insert into user_product_periods(user_product_id, period, code, trust_fiscal_title, created_at)
values ((select id from user_products where code = 'mail_pro_b2c_light_inapp_google'), 'month',
        'mail_pro_b2c_light_inapp_google_month', 'Лайт в Google Play (мес.)', now()),
       ((select id from user_products where code = 'mail_pro_b2c_light_inapp_google'), 'year',
        'mail_pro_b2c_light_inapp_google_year', 'Лайт в Google Play (год)', now()),

       ((select id from user_products where code = 'mail_pro_b2c_light_inapp_apple'), 'month',
        'mail_pro_b2c_light_inapp_apple_month', 'Лайт в App Store (мес.)', now()),
       ((select id from user_products where code = 'mail_pro_b2c_light_inapp_apple'), 'year',
        'mail_pro_b2c_light_inapp_apple_year', 'Лайт в App Store (год)', now());


with data as (
    select 129 as price, 'mail_pro_b2c_light_inapp_google_month' as code
    union all
    select 1150, 'mail_pro_b2c_light_inapp_google_year'
    union all
    select 129, 'mail_pro_b2c_light_inapp_apple_month'
    union all
    select 1150, 'mail_pro_b2c_light_inapp_apple_year'
)
insert
into user_product_prices (created_at, region_id, price, currency, user_product_period_id)
select now(), 10000, d.price, 'RUB', p.id
from data d
         join user_product_periods p on p.code = d.code;

with sets as (
    select *
    from product_sets
    where key in ('inapp_android', 'inapp_ios')),
     lines as (
         select *
         from product_lines
         where product_set_id in (select id from sets))
insert
into user_products_to_product_lines(product_line_id, user_product_id, order_num)
select l.id,
       p.id,
       0
from (select * from user_products where code like '%inapp%' and code like '%light%') p
         join sets s on (s.key = 'inapp_android' and p.code like '%google') or
                        (s.key = 'inapp_ios' and p.code like '%apple%')
         join lines l on l.product_set_id = s.id;

insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num)
select inapp.id,
       pf.feature_id,
       pf.amount,
       now(),
       pf.description_tanker_key_id,
       pf.enabled,
       pf.group_tanker_key_id,
       pf.value_tanker_key_id,
       pf.order_num
from user_products inapp
         join user_products orig on orig.code = replace(replace(inapp.code, '_inapp_google', ''), '_inapp_apple', '')
         join product_features pf on orig.id = pf.user_product_id
where inapp.code like '%inapp%'
  and inapp.code like '%light%'
  and pf.enabled = true;


update user_product_periods
set package_name = 'ru.yandex.mail'
where user_product_id in
      (select id from user_products where billing_type in ('inapp_google', 'inapp_apple'));
