/* pgmigrate-encoding: utf-8 */
alter table product_features
    add column code text null;

update product_features as pf
set code = (select case
                       when f.code = 'mpfs_disk_space_for_mail_pro' then 'mpfs_disk_space'
                       when f.code = 'mpfs_disk_space_for_mail_360' then 'mpfs_disk_space'
                       when f.code = 'mpfs_disk_space_for_b2b_mail_360' then 'mpfs_disk_space'
                       else f.code end
            from features f
            where f.id = pf.feature_id)
where feature_id is not null;


update product_features as pf
set code = (select case
                       when k.key = 'features-90d-history-title' then 'mail_pro_b2c_ext_history'
                       when k.key = 'features-no-ad-disk-title' then 'mail_pro_b2c_advertise_free'
                       when k.key = 'pochta_disk_advertise_fee' then 'mail_pro_b2c_advertise_free'
                       when k.key = 'priority_support' then 'mail_pro_b2c_priority_support'
                       else k.key end
            from tanker_keys k
            where pf.description_tanker_key_id = k.id)
where feature_id is null;

