/* pgmigrate-encoding: utf-8 */
create table user_product_buckets
(
    id              UUID      NOT NULL DEFAULT uuid_generate_v4(),
    code            TEXT      NOT NULL,
    created_at      timestamp NOT NULL,
    user_product_id UUID      NULL,
    product_line_id UUID      NULL,
    product_set_id  UUID      null,
    PRIMARY KEY (id),
    constraint fk_user_product foreign key (user_product_id)
        references user_products on delete restrict,
    constraint fk_product_line foreign key (product_line_id)
        references product_lines on delete RESTRICT,
    constraint fk_product_set foreign key (product_set_id)
        references product_sets on delete RESTRICT
);
CREATE INDEX user_product_buckets_user_product on user_product_buckets (user_product_id);
CREATE INDEX user_product_buckets_product_line on user_product_buckets (product_line_id);
CREATE INDEX user_product_buckets_product_set on user_product_buckets (product_set_id);


insert into user_product_buckets(code, created_at, product_set_id)
select 'mail360', now(), id
from product_sets ps
where ps.key in ('yandexmail', 'mail_pro_b2c', 'inapp_android', 'inapp_ios');


CREATE OR REPLACE FUNCTION on_product_line_delete() RETURNS TRIGGER AS
$$
BEGIN
    IF (TG_OP = 'DELETE') THEN
       IF(SELECT TRUE
           FROM user_product_buckets b
           where b.product_set_id = OLD.product_set_id
           limit 1) THEN
           RAISE EXCEPTION 'Unable to delete product line % because its productset exists in bucket of conflicting products', OLD.id;
       END IF;
       IF(SELECT TRUE
           FROM user_product_buckets b
           where b.product_line_id = OLD.id
           limit 1) THEN
            RAISE EXCEPTION 'Unable to delete product line % because it exists in bucket of conflicting products', OLD.id;
       END IF;
    END IF;
    RETURN NULL;
END;
$$ LANGUAGE plpgsql VOLATILE;

CREATE TRIGGER delete_product_line_trigger
    BEFORE DELETE
    ON product_lines
    FOR EACH ROW
EXECUTE PROCEDURE on_product_line_delete();


CREATE OR REPLACE FUNCTION on_delete_product_from_product_line() RETURNS TRIGGER AS
$$
BEGIN
    IF (TG_OP = 'DELETE') THEN
        IF(SELECT TRUE
           FROM user_product_buckets b
           where b.user_product_id = OLD.user_product_id
           limit 1) THEN
            RAISE EXCEPTION 'Unable to delete user product % from product line % because user product exists in bucket of conflicting products', OLD.user_product_id, OLD.product_line_id;
        END IF;
        IF(SELECT TRUE
           FROM user_product_buckets b
           where b.product_line_id = OLD.product_line_id
           limit 1) THEN
            RAISE EXCEPTION 'Unable to delete user product % from product line % because product line exists in bucket of conflicting products', OLD.user_product_id, OLD.product_line_id;
        END IF;
        IF(SELECT TRUE
           FROM user_product_buckets b
            join product_lines pl on b.product_set_id = pl.product_set_id
           where pl.id = OLD.product_line_id
           limit 1) THEN
            RAISE EXCEPTION 'Unable to delete user product % from product line % because product set exists in bucket of conflicting products', OLD.user_product_id, OLD.product_line_id;
        END IF;
    END IF;
    RETURN NULL;
END;
$$ LANGUAGE plpgsql VOLATILE;

CREATE TRIGGER delete_product_from_product_line_trigger
    BEFORE DELETE
    ON user_products_to_product_lines
    FOR EACH ROW
EXECUTE PROCEDURE on_delete_product_from_product_line();
