/* pgmigrate-encoding: utf-8 */
insert into product_sets(key, created_at)
VALUES ('inapp_ios_disk', now());

insert into user_product_buckets (code, created_at, user_product_id, product_line_id, product_set_id)
values ('mail360', now(), null, null, (select id from product_sets where key = 'inapp_ios_disk'));

update product_sets
set key = 'inapp_ios_mail'
where key = 'inapp_ios';

insert into product_lines(product_set_id, created_at, order_num, selector_bean_el)
VALUES ((select id from product_sets where key = 'inapp_ios_disk'),
        now(), 1, 'productLineSelectorFactory.availableSelector()');

insert into user_products(code, created_at, updated_at, title_tanker_key_id, is_best_offer, product_owner_id,
                          available_from, billing_type, allow_auto_prolong, trust_subs_retry_charging_limit,
                          trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id,
                          trial_definition_id)
select code || '_for_disk',
       now(),
       now(),
       title_tanker_key_id,
       is_best_offer,
       product_owner_id,
       available_from,
       billing_type,
       allow_auto_prolong,
       trust_subs_retry_charging_limit,
       trust_subs_retry_charging_delay,
       trust_subs_grace_period,
       singleton,
       trust_service_id,
       trial_definition_id
from user_products
where code like '%_inapp_apple';

insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
VALUES ((select l.id
         from product_lines l
         where l.product_set_id = (select id from product_sets where key = 'inapp_ios_disk')),
        (select id from user_products where code = 'mail_pro_b2c_light_inapp_apple_for_disk'), 1),
       ((select l.id
         from product_lines l
         where l.product_set_id = (select id from product_sets where key = 'inapp_ios_disk')),
        (select id from user_products where code = 'mail_pro_b2c_standard100_inapp_apple_for_disk'), 2),
       ((select l.id
         from product_lines l
         where l.product_set_id = (select id from product_sets where key = 'inapp_ios_disk')),
        (select id from user_products where code = 'mail_pro_b2c_premium1000_inapp_apple_for_disk'), 3),
       ((select l.id
         from product_lines l
         where l.product_set_id = (select id from product_sets where key = 'inapp_ios_disk')),
        (select id from user_products where code = 'mail_pro_b2c_premium3000_inapp_apple_for_disk'), 4),
       ((select l.id
         from product_lines l
         where l.product_set_id = (select id from product_sets where key = 'inapp_ios_disk')),
        (select id from user_products where code = 'mail_pro_b2c_premium5000_inapp_apple_for_disk'), 5);

insert into product_features (user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                              group_tanker_key_id, value_tanker_key_id, order_num, code)
select (select id from user_products where code = up.code || '_for_disk'),
       pf.feature_id,
       pf.amount,
       now(),
       pf.description_tanker_key_id,
       pf.enabled,
       pf.group_tanker_key_id,
       pf.value_tanker_key_id,
       pf.order_num,
       pf.code
from product_features pf
         join user_products up on pf.user_product_id = up.id
where up.code like '%_inapp_apple';

insert into user_product_periods(user_product_id, period, code, trust_fiscal_title, created_at, package_name)
select (select id from user_products where code = up.code || '_for_disk'),
       upp.period,
       replace(upp.code, 'inapp_apple', 'inapp_apple_for_disk'),
       upp.trust_fiscal_title,
       now(),
       'ru.yandex.disk'
from user_product_periods upp
         join user_products up on upp.user_product_id = up.id
where up.code like '%_inapp_apple';

insert into user_product_prices(created_at, region_id, price, currency, display_discount_percent,
                                display_original_price, user_product_period_id)


select now(),
       uppr.region_id,
       uppr.price,
       uppr.currency,
       uppr.display_discount_percent,
       uppr.display_original_price,
       (select id from user_product_periods where code = replace(upp.code, 'inapp_apple', 'inapp_apple_for_disk'))
from user_product_prices uppr
         join user_product_periods upp on uppr.user_product_period_id = upp.id
         join user_products up on upp.user_product_id = up.id
where up.code like '%_inapp_apple';
