/* pgmigrate-encoding: utf-8 */
update product_features
set order_num = order_num + 1
where order_num <> 999
  and order_num >= 3
  and user_product_id in (select id
                          from user_products
                          where code = 'b2c_mail_pro_for_staff_v1');

insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code)
select p.id,
       f.id,
       1,
       now(),
       null,
       true,
       (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'features'
          and key = 'mail_pro_b2c_group_mail'
       ),
       null, 3,
       'mail_b2c_domain_enabled'
from user_products p
         join features f on f.code = 'mail_b2c_domain_enabled'
where p.code = 'b2c_mail_pro_for_staff_v1';

update user_services
set status            = 'init',
    updated_at        = now(),
    status_updated_at = now()
where target = 'enabled'
  and user_product_id in (
    select f.user_product_id
    from product_features f
    where f.code = 'mail_b2c_domain_enabled'
);
