insert into trial_definitions(created_at, type, end_date, duration, duration_measurement, price,
                              single_usage_comparison_key)
select now(),
       'constant_period',
       null,
       30,
       'day',
       0,
       t.single_usage_comparison_key
from trial_definitions t
where t.id in (select g.trial_definition_id from group_products g where g.code = 'org_mail_pro_standard100');


insert into group_products(code, created_at, updated_at, user_product_id, balance_product_name,
                           price, currency, singleton, trial_definition_id, available_to,
                           title_tanker_key_id)
select 'org_mail_pro_standard100_trial30',
       now(),
       now(),
       g.user_product_id,
       g.balance_product_name,
       g.price,
       g.currency,
       g.singleton,
       (select t.id
        from trial_definitions t
        where t.duration = 30
          and t.duration_measurement = 'day'
          and t.single_usage_comparison_key in
              (select td.single_usage_comparison_key from trial_definitions td where td.id = g.trial_definition_id)),
       g.available_to,
       g.title_tanker_key_id
from group_products g
where g.code = 'org_mail_pro_standard100';


update product_lines
set order_num = order_num + 1
where order_num > 1
  and product_set_id = (select s.id
                        from product_sets s
                        where s.key = 'mail_pro_b2b');

insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
select s.id,
       now(),
       2,
       'productLineSelectorFactory.availableFromSelector("2021-03-01", productLineSelectorFactory.availableSelector())'
from product_sets s
where s.key = 'mail_pro_b2b';


with previous(product_line_id) as (select l.id
                                   from product_lines l
                                   where l.product_set_id =
                                         (select s.id from product_sets s where s.key = 'mail_pro_b2b')
                                     and l.order_num = 3)

insert
into group_products_to_product_lines (product_line_id, group_product_id, order_num)
select (select pl.id
        from product_lines pl
        where pl.selector_bean_el =
              'productLineSelectorFactory.availableFromSelector("2021-03-01", productLineSelectorFactory.availableSelector())'),
       lines.group_product_id,
       lines.order_num
from group_products_to_product_lines lines
where lines.product_line_id = (select product_line_id from previous);


with product(product_line_id) as (select l.id
                                  from product_lines l
                                  where l.product_set_id =
                                        (select s.id from product_sets s where s.key = 'mail_pro_b2b')
                                    and l.order_num = 2)

update group_products_to_product_lines
set group_product_id = (select p.id from group_products p where p.code = 'org_mail_pro_standard100_trial30')
where product_line_id = (select product_line_id from product)
  and group_product_id = (select g.id
                          from group_products g
                          where g.code = 'org_mail_pro_standard100');



with product(group_product_id) as (select p.id from group_products p where p.code = 'org_mail_pro_standard100_trial30')
insert
into bucket_content (bucket_code, group_product_id, updated_at)
values ('group1', (select group_product_id from product), now()),
       ('group2', (select group_product_id from product), now());

