/* pgmigrate-encoding: utf-8 */
-- CHEMODAN-76447
-- mail_b2c_can_use_backup
insert into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
                     activation_url_http_method, activation_url_template, set_amount_url_http_method,
                     set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
                     call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
                     set_amount_body_template, deactivation_body_template, activation_content_type,
                     deactivation_content_type, set_amount_content_type, error_processor_name)
select 'mail_b2c_can_use_backup',
       now(),
       now(),
       f.system_tvm_id,
       f.type,
       'Фича "Бэкап ящика" в Яндекс.Почте',
       f.system_name,
       f.activation_url_http_method,
       f.activation_url_template,
       f.set_amount_url_http_method,
       f.set_amount_url_template,
       f.deactivation_url_http_method,
       f.deactivation_url_template,
       f.call_set_amount_on_activation,
       f.call_set_amount_on_deactivation,
       'mail_b2c_can_use_backup=on',
       f.set_amount_body_template,
       'mail_b2c_can_use_backup=',
       f.activation_content_type,
       f.deactivation_content_type,
       f.set_amount_content_type,
       f.error_processor_name
from features f
where f.code = 'mail_b2c_domain_enabled';


insert into tanker_keys(created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'features', 'mail_b2c_can_use_backup');

update product_features
set order_num = order_num + 1
where order_num <> 999
  and order_num >= 3
  and user_product_id in
    (
        select id
        from user_products
        where code like '%b2c%'
            and (code like '%standard%' or code like '%premium%')
            or code = 'b2c_mail_pro_test'
    );


insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code)
select p.id,
       f.id,
       1,
       now(),
       null, --description_tanker_key_id=null is the crunch for hidden by default feature
       true,
       (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'features'
          and key = 'mail_pro_b2c_group_mail'
       ),
       null, 3,
       f.code
from user_products p
         join features f on f.code = 'mail_b2c_can_use_backup'
where p.code in
    (
        select code
        from user_products
        where code like '%b2c%'
            and (code like '%standard%' or code like '%premium%')
            or code = 'b2c_mail_pro_test'
    );

-- mail_b2c_can_use_hidden_trash
insert into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
                     activation_url_http_method, activation_url_template, set_amount_url_http_method,
                     set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
                     call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
                     set_amount_body_template, deactivation_body_template, activation_content_type,
                     deactivation_content_type, set_amount_content_type, error_processor_name)
select 'mail_b2c_can_use_hidden_trash',
       now(),
       now(),
       f.system_tvm_id,
       f.type,
       'Фича "Продленное хранение удаленных" в Яндекс.Почте',
       f.system_name,
       f.activation_url_http_method,
       f.activation_url_template,
       f.set_amount_url_http_method,
       f.set_amount_url_template,
       f.deactivation_url_http_method,
       f.deactivation_url_template,
       f.call_set_amount_on_activation,
       f.call_set_amount_on_deactivation,
       'mail_b2c_can_use_hidden_trash=on',
       f.set_amount_body_template,
       'mail_b2c_can_use_hidden_trash=',
       f.activation_content_type,
       f.deactivation_content_type,
       f.set_amount_content_type,
       f.error_processor_name
from features f
where f.code = 'mail_b2c_domain_enabled';


insert into tanker_keys(created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'features', 'mail_b2c_can_use_hidden_trash');

update product_features
set order_num = order_num + 1
where order_num <> 999
  and order_num >= 3
  and user_product_id in
    (
        select id
        from user_products
        where code like '%b2c%'
            and (code like '%standard%' or code like '%premium%')
            or code = 'b2c_mail_pro_test'
    );


insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code)
select p.id,
       f.id,
       1,
       now(),
       null, --description_tanker_key_id=null hidden feature
       true,
       (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'features'
          and key = 'mail_pro_b2c_group_mail'
       ),
       null, 3,
       f.code
from user_products p
         join features f on f.code = 'mail_b2c_can_use_hidden_trash'
where p.code in
    (
        select code
        from user_products
        where code like '%b2c%'
            and (code like '%standard%' or code like '%premium%')
            or code = 'b2c_mail_pro_test'
    );

update user_services
set status = 'init', updated_at = now(), status_updated_at = now()
where target = 'enabled'
    and user_product_id in
     (
        select f.user_product_id
        from product_features f
        where f.code = 'mail_b2c_domain_enabled'
     );
