/* pgmigrate-encoding: utf-8 */

create table email_templates
(
    key         text      NOT NULL,
    args        text,
    description text      NOT NULL,
    created_at  timestamp not null,
    PRIMARY KEY (key)
);
comment on table email_templates is 'список кодов шаблонов писем';
comment on column email_templates.description is 'описание письма. Не участвует в логике';

create table email_templates_localized
(
    template_key text NOT NULL REFERENCES email_templates,
    locale       text not null,
    sender_code  text not null,

    UNIQUE (template_key, locale)
);
comment on table email_templates_localized is 'список локализированных шаблонов писем';
comment on column email_templates_localized.sender_code is 'код шаблона текста письма в рассыляторе';


create type promo_application_area as enum ('global', 'per_user');
create type promo_application_type as enum ('one_time', 'multiple_time');

CREATE TABLE promo_templates
(
    id                           UUID                   NOT NULL DEFAULT uuid_generate_v4(),
    description                  TEXT                   NOT NULL,
    promo_name_tanker_key_id     uuid REFERENCES tanker_keys,
    from_date                    timestamp              NOT NULL,
    to_date                      timestamp,
    application_area             promo_application_area NOT NULL,
    application_type             promo_application_type NOT NULL,
    duration                     numeric,
    duration_measurement         TEXT,
    activation_email_template_key text REFERENCES email_templates,
    created_at                   timestamp              not null,

    PRIMARY KEY (id)
);
comment on table promo_templates is 'список возможных промо акций';
create index promo_templates_activation_email_template_id_i on promo_templates (activation_email_template_key);
create index promo_templates_promo_name_tanker_key_id_i on promo_templates (promo_name_tanker_key_id);

create type user_promos_status as enum ('active', 'used');
CREATE TABLE user_promos
(
    id                UUID               NOT NULL DEFAULT uuid_generate_v4(),
    promo_template_id UUID references promo_templates,
    uid               text               not null,
    from_date         timestamp          not null,
    to_date           timestamp,
    status            user_promos_status not null,
    created_at        timestamp          not null,

    PRIMARY KEY (id),
    unique (promo_template_id, uid)
);
comment on table user_promos is 'список промо акций, активированных для пользователей';


create table promo_product_lines
(
    promo_template_id uuid
        constraint promo_product_lines_product_lines_fk
            references promo_templates on delete cascade,
    product_line_id   uuid
        constraint promo_product_lines_promo_templates_fk
            references product_lines on delete cascade,

    PRIMARY KEY (promo_template_id, product_line_id)
);
comment on table promo_product_lines is 'линейки продуктов, входящие в промо акцию';
create index promo_product_lines_promo_template_id_i on promo_product_lines (promo_template_id);
create index promo_product_lines_product_line_id_i on promo_product_lines (product_line_id);
