insert into user_products(code, created_at, updated_at, title_tanker_key_id, is_best_offer, product_owner_id,
                          available_from, billing_type, allow_auto_prolong, trust_subs_retry_charging_limit,
                          trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id,
                          trial_definition_id)
select distinct replace(up.code || '_v2', 'v2_v2', 'v3'),
                now(),
                now(),
                up.title_tanker_key_id,
                up.is_best_offer,
                up.product_owner_id,
                up.available_from,
                up.billing_type,
                up.allow_auto_prolong,
                up.trust_subs_retry_charging_limit,
                up.trust_subs_retry_charging_delay,
                up.trust_subs_grace_period,
                up.singleton,
                up.trust_service_id,
                up.trial_definition_id
from product_sets ps
         join product_lines pl on ps.id = pl.product_set_id
         join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
         join user_products up on up.id = uptpl.user_product_id
where ps.key = 'mail_pro_b2c'
  and (up.code like '%light%' or up.code like '%standard%');

--------------------------- user_products_to_product_lines
with ids as (
    select upOld.id as oldId, upNew.id as newId
    from user_products upOld
             join user_products upNew on replace(upOld.code || '_v2', 'v2_v2', 'v3') = upNew.code
)
insert
into user_products_to_product_lines (product_line_id, user_product_id, order_num)
select uptpl.product_line_id, ids.newId, uptpl.order_num
from user_products_to_product_lines uptpl
         join ids on uptpl.user_product_id = ids.oldId;

--------------------------- user_product_buckets
with ids as (
    select upOld.id as oldId, upNew.id as newId
    from user_products upOld
             join user_products upNew on replace(upOld.code || '_v2', 'v2_v2', 'v3') = upNew.code
)
insert
into user_product_buckets (code, created_at, user_product_id, product_line_id, product_set_id)
select upb.code, now(), ids.oldId, upb.product_line_id, upb.product_set_id
from user_product_buckets upb
         join public.product_sets ps on ps.id = upb.product_set_id
         join public.product_lines pl on pl.product_set_id = ps.id
         join user_products_to_product_lines uptpl on uptpl.product_line_id = pl.id
         join ids on ids.oldId = uptpl.user_product_id;

--------------------------- user_product_periods
    with ids as (
    select upOld.id as oldId, upNew.id as newId, upOld.code as oldCode, upNew.code as newCode
    from user_products upOld
             join user_products upNew on replace(upOld.code || '_v2', 'v2_v2', 'v3') = upNew.code
)
insert
into user_product_periods (user_product_id, period, code, trust_fiscal_title, created_at, package_name)
select ids.newId,
       upp.period,
       replace(upp.code, ids.oldCode, ids.newCode),
       upp.trust_fiscal_title,
       now(),
       upp.package_name
from user_product_periods upp
         join ids on upp.user_product_id = ids.oldId;

--------------------------- user_product_prices
with periods as (
    select prOld.id as oldPeriodId, prNew.id as newPeriodId
    from user_products upOld
             join user_products upNew on replace(upOld.code || '_v2', 'v2_v2', 'v3') = upNew.code
             join user_product_periods prNew on prNew.user_product_id = upNew.id
             join user_product_periods prOld on prOld.user_product_id = upOld.id and prNew.period = prOld.period
)
insert
into user_product_prices (created_at, region_id, price, currency, display_discount_percent, display_original_price,
                          user_product_period_id)
select now(),
       upp.region_id,
       replace(
               replace(
                       replace(upp.price::text,
                               '79', '69'),
                       '139', '99'),
               '111', '79')::numeric,
       upp.currency,
       upp.display_discount_percent,
       replace(
               replace(upp.display_original_price::text,
                       '79', '69'),
               '139', '99')::numeric,
       p.newPeriodId
from user_product_prices upp
         join periods p on upp.user_product_period_id = p.oldPeriodId;

--------------------------- product_features

with ids as (
    select upOld.id as oldId, upNew.id as newId
    from user_products upOld
             join user_products upNew on replace(upOld.code || '_v2', 'v2_v2', 'v3') = upNew.code
)
insert
into product_features (user_product_id, feature_id, amount, created_at, description_tanker_key_id, group_tanker_key_id,
                       value_tanker_key_id, enabled, order_num, code)
select ids.newId,
       feature_id,
       amount,
       now(),
       description_tanker_key_id,
       group_tanker_key_id,
       value_tanker_key_id,
       enabled,
       order_num,
       code
from product_features pf
         join ids on pf.user_product_id = ids.oldId;

--------------------------- delete old products
ALTER TABLE public.user_products_to_product_lines
    DISABLE TRIGGER delete_product_from_product_line_trigger;

with ids as (
    select upOld.id as oldId, upNew.id as newId
    from user_products upOld
             join user_products upNew on replace(upOld.code || '_v2', 'v2_v2', 'v3') = upNew.code
)
delete
from user_products_to_product_lines uppl
where uppl.user_product_id in (select oldId from ids);

ALTER TABLE public.user_products_to_product_lines
    ENABLE TRIGGER delete_product_from_product_line_trigger;
