/* pgmigrate-encoding: utf-8 */
alter table promo_templates
    add code text not null;

create unique index promo_templates_code_idx on promo_templates (code);

insert into email_templates(key, args, description, created_at)
values ('newbie_discount_email', 'public_display_name;promo_to_date',
        'Письмо о предоставлении скидки на почту 360 новичку',
        now());

insert into email_templates_localized(template_key, locale, sender_code)
values ('newbie_discount_email', 'ru', 'SJRHXTY3-7PS');

insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('newbie', 'Скидка новичкам', null, now(), null, 'per_user'::promo_application_area,
        'multiple_time'::promo_application_type, 5, 'day', 'newbie_discount_email', now());


------------------------------------------
----------- create discounted products
------------------------------------------
insert into user_products(code, created_at, updated_at, title_tanker_key_id, is_best_offer, product_owner_id,
                          available_from, billing_type, allow_auto_prolong, trust_subs_retry_charging_limit,
                          trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id,
                          trial_definition_id)
select case when (code like '%_v2') then replace(code, '_v2', '_discount20_v2') else code || '_discount20' end,
       now(),
       now(),
       title_tanker_key_id,
       is_best_offer,
       product_owner_id,
       available_from,
       billing_type,
       allow_auto_prolong,
       trust_subs_retry_charging_limit,
       trust_subs_retry_charging_delay,
       trust_subs_grace_period,
       singleton,
       trust_service_id,
       trial_definition_id
from user_products
where code in
      ('mail_pro_b2c_light_v2', 'mail_pro_b2c_standard100_v2', 'mail_pro_b2c_premium1000', 'mail_pro_b2c_premium3000',
       'mail_pro_b2c_premium5000');

insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code)
select new_p.id,
       pf.feature_id,
       pf.amount,
       now(),
       pf.description_tanker_key_id,
       pf.enabled,
       pf.group_tanker_key_id,
       pf.value_tanker_key_id,
       pf.order_num,
       pf.code
from product_features pf
         join user_products old_p on pf.user_product_id = old_p.id
         join user_products new_p
              on old_p.code = replace(new_p.code, '_discount20', '') and new_p.code like '%discount20%'
where old_p.code in
      ('mail_pro_b2c_light_v2', 'mail_pro_b2c_standard100_v2', 'mail_pro_b2c_premium1000',
       'mail_pro_b2c_premium3000',
       'mail_pro_b2c_premium5000');


insert into user_product_periods(user_product_id, period, code, trust_fiscal_title, created_at, package_name)
select new_p.id,
       upp.period,
       new_p.code || '_' || period || '_subs',
       upp.trust_fiscal_title || ' (скидка -20%)',
       now(),
       upp.package_name
from user_product_periods upp
         join user_products old_p on upp.user_product_id = old_p.id
         join user_products new_p
              on old_p.code = replace(new_p.code, '_discount20', '') and new_p.code like '%discount20%'
where old_p.code in
      ('mail_pro_b2c_light_v2', 'mail_pro_b2c_standard100_v2', 'mail_pro_b2c_premium1000',
       'mail_pro_b2c_premium3000',
       'mail_pro_b2c_premium5000');

with prices as (
    select 55 price, 'month' as period, 69 as display_original_price, 'mail_pro_b2c_light_discount20_v2' as product_code
    union all
    select 552                                   price,
           'year'                             as period,
           690                                as display_original_price,
           'mail_pro_b2c_light_discount20_v2' as product_code
    union all
    select 79                                          price,
           'month'                                  as period,
           99                                       as display_original_price,
           'mail_pro_b2c_standard100_discount20_v2' as product_code
    union all
    select 792                                         price,
           'year'                                   as period,
           990                                      as display_original_price,
           'mail_pro_b2c_standard100_discount20_v2' as product_code

    union all
    select 239                                      price,
           'month'                               as period,
           299                                   as display_original_price,
           'mail_pro_b2c_premium1000_discount20' as product_code
    union all
    select 1992                                     price,
           'year'                                as period,
           2490                                  as display_original_price,
           'mail_pro_b2c_premium1000_discount20' as product_code

    union all
    select 599                                      price,
           'month'                               as period,
           749                                   as display_original_price,
           'mail_pro_b2c_premium3000_discount20' as product_code
    union all
    select 5752                                     price,
           'year'                                as period,
           7190                                  as display_original_price,
           'mail_pro_b2c_premium3000_discount20' as product_code

    union all
    select 895                                      price,
           'month'                               as period,
           1119                                  as display_original_price,
           'mail_pro_b2c_premium5000_discount20' as product_code
    union all
    select 8952                                     price,
           'year'                                as period,
           11190                                 as display_original_price,
           'mail_pro_b2c_premium5000_discount20' as product_code
)
insert
into user_product_prices(created_at, region_id, price, currency, display_discount_percent, display_original_price,
                         user_product_period_id)
select now(), 10000, p.price, 'RUB', 20, p.display_original_price, upp.id
from user_products up
         join user_product_periods upp on up.id = upp.user_product_id
         join prices p on p.product_code = up.code and upp.period = p.period;


------------------------------------------
----------- create product line and bind it to promo template
------------------------------------------
insert into product_lines
    (product_set_id, created_at, order_num, selector_bean_el)
VALUES ((select id from product_sets where key = 'mail_pro_b2c'),
        now(), 1001, 'productLineSelectorFactory.availableSelector()');

insert into user_products_to_product_lines(product_line_id, user_product_id, order_num)
values ((select l.id
         from product_lines l
                  join product_sets ps on l.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and l.order_num = 1001),
        (select id from user_products where code = 'mail_pro_b2c_light_v2'),
        1),
       ((select l.id
         from product_lines l
                  join product_sets ps on l.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and l.order_num = 1001),
        (select id from user_products where code = 'mail_pro_b2c_standard100_discount20_v2'),
        2),

       ((select l.id
         from product_lines l
                  join product_sets ps on l.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and l.order_num = 1001),
        (select id from user_products where code = 'mail_pro_b2c_premium1000_discount20'),
        3),
       ((select l.id
         from product_lines l
                  join product_sets ps on l.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and l.order_num = 1001),
        (select id from user_products where code = 'mail_pro_b2c_premium3000_discount20'),
        4),
       ((select l.id
         from product_lines l
                  join product_sets ps on l.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and l.order_num = 1001),
        (select id from user_products where code = 'mail_pro_b2c_premium5000_discount20'),
        5)
;

insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = 'newbie'),
        (select l.id
         from product_lines l
                  join product_sets ps on l.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and l.order_num = 1001));
