-- disable trials
update product_lines pl
set selector_bean_el = 'productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(5))))'
where pl.selector_bean_el =
      'productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(5)))';

update product_lines pl
set selector_bean_el = 'productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(2))))'
where pl.selector_bean_el =
      'productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(2)))';

update product_lines pl
set selector_bean_el = 'productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.availableSelector()))'
where pl.selector_bean_el =
      'productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.availableSelector())';

-- insert new line
update product_lines pl
set order_num = pl.order_num + 1
where pl.order_num >= 6 and pl.order_num <= 1000;

insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
select pl.product_set_id,
       now(),
       6,
       'productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.availableSelector())'
from product_lines pl
         join product_sets ps on pl.product_set_id = ps.id
where selector_bean_el = 'productLineSelectorFactory.availableSelector()'
  and ps.key = 'mail_pro_b2c'
  and pl.order_num < 1000;

-- bind products to line

insert into user_products_to_product_lines
    (
        select newpl.id, uptpl.user_product_id, uptpl.order_num
        from product_lines pl
                 join product_sets ps on pl.product_set_id = ps.id
                 join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
                 join user_products up on uptpl.user_product_id = up.id
                 join product_lines newpl on newpl.order_num = 6
        where pl.selector_bean_el = 'productLineSelectorFactory.availableSelector()'
          and ps.key = 'mail_pro_b2c'
          and pl.order_num < 1000
          and up.code not like '%light%'

        union all
        select newpl.id, up.id, 1
        from user_products up
                 join product_lines newpl on newpl.order_num = 6
        where up.code = 'mail_pro_b2c_light_30days_trial_v3'
    );
