/* pgmigrate-encoding: utf-8 */
insert into user_products
(code, created_at, updated_at, title_tanker_key_id, is_best_offer, product_owner_id, available_from,
 billing_type, allow_auto_prolong, trust_subs_retry_charging_limit, trust_subs_retry_charging_delay,
 trust_subs_grace_period, singleton, trust_service_id, trial_definition_id)
select 'mail_pro_b2c_light_v2_inapp_apple',
       now(),
       now(),
       title_tanker_key_id,
       is_best_offer,
       product_owner_id,
       available_from,
       billing_type,
       allow_auto_prolong,
       trust_subs_retry_charging_limit,
       trust_subs_retry_charging_delay,
       trust_subs_grace_period,
       singleton,
       trust_service_id,
       trial_definition_id
from user_products
where code in ('mail_pro_b2c_light_inapp_apple');


insert into user_product_periods(user_product_id, period, code, trust_fiscal_title, created_at, package_name)
select (select id from user_products where code = 'mail_pro_b2c_light_v2_inapp_apple'),
       period,
       'mail_pro_b2c_light_v2_inapp_apple_' || period,
       trust_fiscal_title,
       now(),
       package_name
from user_product_periods
where code like 'mail_pro_b2c_light_inapp_apple%'
  and code not like 'mail_pro_b2c_light_inapp_apple_for_disk_%';

insert into user_product_prices(created_at, region_id, price, currency, display_discount_percent,
                                display_original_price, user_product_period_id)
select now(), 1000, 129, 'RUB', null::numeric, null::numeric, id
from user_product_periods
where code = 'mail_pro_b2c_light_v2_inapp_apple_month'
union all
select now(), 1000, 1150, 'RUB', null, null, id
from user_product_periods
where code = 'mail_pro_b2c_light_v2_inapp_apple_year';


insert into product_features (user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                              group_tanker_key_id, value_tanker_key_id, order_num, code)

select (select id from user_products where code = 'mail_pro_b2c_light_v2_inapp_apple'),
       feature_id,
       amount,
       now(),
       description_tanker_key_id,
       enabled,
       group_tanker_key_id,
       value_tanker_key_id,
       order_num,
       code
from product_features pf
where user_product_id = (select id from user_products where code = 'mail_pro_b2c_light_inapp_apple');


insert into user_product_buckets(code, created_at, user_product_id, product_line_id, product_set_id)
VALUES ('mail360', now(), (select id from user_products where code = 'mail_pro_b2c_light_inapp_apple'), null, null);

update user_products_to_product_lines
set user_product_id = (select id from user_products where code = 'mail_pro_b2c_light_v2_inapp_apple')
where user_product_id = (select id from user_products where code = 'mail_pro_b2c_light_inapp_apple');

