/* pgmigrate-encoding: utf-8 */

-- добавляем продукты из не актуальных линеек, которые более нигде не используются, в бакет явно
with obsolete_products as
         (
             select beans
             from (
                      values ('productLineSelectorFactory.availableFromSelector("2021-02-01", productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.availableSelector()))'),
                             ('productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(2))))'),
                             ('productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(5))))'),
                             ('productLineSelectorFactory.availableFromSelector("2020-12-01", productLineSelectorFactory.availableUntilSelector("2021-02-01", productLineSelectorFactory.experimentIsActiveSelector("mail_360_new_year_2021")))'),
                             ('productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.availableSelector()))')
                  ) s(beans)
         ),
     actual_products as
         (
             select up.id
             from product_lines pl
                      join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
                      join user_products up on uptpl.user_product_id = up.id
             where pl.selector_bean_el not in (select * from obsolete_products)
             order by pl.order_num
         ),
     not_actual_products as
         (
             select up.id
             from product_lines pl
                      join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
                      join user_products up on uptpl.user_product_id = up.id
             where pl.selector_bean_el in (select * from obsolete_products)
             order by pl.order_num)
insert
into user_product_buckets (code, created_at, user_product_id, product_line_id, product_set_id)
select distinct 'mail360', now(), nap.id, null::uuid, null::uuid
from not_actual_products nap
         left join actual_products ap
                   on nap.id = ap.id
where ap.id is null;

-- заодно почистим старые ошибки
update user_product_buckets
set product_set_id = null
where user_product_id is not null;

-- удаляем продукты из старых линеек
ALTER TABLE public.user_products_to_product_lines
    DISABLE TRIGGER delete_product_from_product_line_trigger;

delete
from user_products_to_product_lines uptpl
where uptpl.product_line_id in
      (select pl.id
       from product_lines pl
       where pl.selector_bean_el in
             ('productLineSelectorFactory.availableFromSelector("2021-02-01", productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.availableSelector()))',
              'productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(2))))',
              'productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(5))))',
              'productLineSelectorFactory.availableFromSelector("2020-12-01", productLineSelectorFactory.availableUntilSelector("2021-02-01", productLineSelectorFactory.experimentIsActiveSelector("mail_360_new_year_2021")))',
              'productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.availableSelector()))'
                 ));

ALTER TABLE public.user_products_to_product_lines
    ENABLE TRIGGER delete_product_from_product_line_trigger;


-- удаляем старые линейки
ALTER TABLE public.product_lines
    DISABLE TRIGGER delete_product_line_trigger;

delete
from product_lines pl
where pl.selector_bean_el in
      ('productLineSelectorFactory.availableFromSelector("2021-02-01", productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.availableSelector()))',
       'productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(2))))',
       'productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.regDateOlderThanSelector(T(org.joda.time.Period).years(5))))',
       'productLineSelectorFactory.availableFromSelector("2020-12-01", productLineSelectorFactory.availableUntilSelector("2021-02-01", productLineSelectorFactory.experimentIsActiveSelector("mail_360_new_year_2021")))',
       'productLineSelectorFactory.availableUntilSelector("2021-04-01", productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.availableSelector()))'
          );

ALTER TABLE public.product_lines
    DISABLE TRIGGER delete_product_line_trigger;
-- чистим бакеты - удаляем продукты, добавленные явно, если они уже есть в бакете из за product_set
delete
from user_product_buckets
where id in (
    with product_set_products as (
        select distinct up.id
        from user_product_buckets upb
                 join product_sets ps on ps.id = upb.product_set_id
                 join product_lines pl on ps.id = pl.product_set_id
                 join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
                 join user_products up on uptpl.user_product_id = up.id
    )
    select upb.user_product_id
    from user_product_buckets upb
             join product_set_products psp on psp.id = upb.user_product_id
    where upb.user_product_id is not null
);

-- добавляем новые линейки
-- дефолтная с экспериментом
insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1,
        'productLineSelectorFactory.experimentIsActiveSelector("mail_360_new_price_exp")');

-- скидочная с экспериментом
insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1000,
        'productLineSelectorFactory.experimentIsActiveSelector("mail_360_new_price_exp")');

-- двигаем порядок линеек вниз с учетом 2х новых
update product_lines pl
set order_num = 2
where order_num = 6;
update product_lines pl
set order_num = 3
where order_num = 7;
update product_lines pl
set order_num = order_num + 1
where order_num >= 1000;

-- создаем временную табличку для копирования продуктов
create table product_map
(
    old_id   uuid,
    old_code text,
    new_id   uuid,
    new_code text
);

insert into product_map (old_id, old_code, new_id, new_code)
select distinct up.id                                                           as old_id,
                up.code                                                         as old_code,
                null::uuid                                                      as new_id,
                replace(up.code || '_v20210525', '_v2_v20210525', '_v20210525') as new_code
from user_products up
where up.code in ('mail_pro_b2c_premium1000',
                  'mail_pro_b2c_premium1000_discount20',
                  'mail_pro_b2c_premium3000',
                  'mail_pro_b2c_premium3000_discount20',
                  'mail_pro_b2c_premium5000',
                  'mail_pro_b2c_premium5000_discount20',
                  'mail_pro_b2c_standard100_discount20_v2',
                  'mail_pro_b2c_standard100_v2')
union all
select distinct up.id                                                           as old_id,
                up.code                                                         as old_code,
                null::uuid,
                replace(up.code || '_v20210525', 'premium5000', 'premium10000') as new_code
from user_products up
where up.code in ('mail_pro_b2c_premium5000',
                  'mail_pro_b2c_premium5000_discount20');

-- копируем продукты
insert
into user_products(code, created_at, updated_at, title_tanker_key_id, is_best_offer, product_owner_id,
                   available_from, billing_type, allow_auto_prolong, trust_subs_retry_charging_limit,
                   trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id,
                   trial_definition_id)
select distinct pm.new_code,
                now(),
                now(),
                up.title_tanker_key_id,
                up.is_best_offer,
                up.product_owner_id,
                up.available_from,
                up.billing_type,
                up.allow_auto_prolong,
                up.trust_subs_retry_charging_limit,
                up.trust_subs_retry_charging_delay,
                up.trust_subs_grace_period,
                up.singleton,
                up.trust_service_id,
                up.trial_definition_id
from user_products up
         join product_map pm on pm.old_id = up.id;

-- добавляем новый продукт "Премиум 10 ТБ"
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_premium10000');

update user_products
set title_tanker_key_id = (select id
                           from tanker_keys
                           where project = 'disk-ps-billing'
                             and key_set = 'products'
                             and key = 'mail_pro_b2c_premium10000')
where code like '%premium10000%';

-- обновляем айди продуктов в мапе
update product_map
set new_id = (select id from user_products up where up.code = new_code);

-- копируем фичи продуков
insert into product_features (user_product_id, feature_id, amount, created_at, description_tanker_key_id,
                              group_tanker_key_id,
                              value_tanker_key_id, enabled, order_num, code)
select pm.new_id,
       feature_id,
       amount,
       now(),
       description_tanker_key_id,
       group_tanker_key_id,
       value_tanker_key_id,
       enabled,
       order_num,
       code
from product_features pf
         join product_map pm on pm.old_id = pf.user_product_id;

-- для новых продуктов увеличиваем объем и меняем тайтл значения


insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'features', 'mail_pro_add_10tb');

update product_features
set amount              = 10995116277760,
    value_tanker_key_id = (select id
                           from tanker_keys
                           where project = 'disk-ps-billing'
                             and key_set = 'features'
                             and key = 'mail_pro_add_10tb')
where user_product_id in (select new_id
                          from product_map pm
                          where pm.new_code like '%premium10000%')
  and amount > 1;

-- копируем user_product_periods
insert
into user_product_periods (user_product_id, period, code, trust_fiscal_title, created_at, package_name)
select pm.new_id,
       upp.period,
       replace(upp.code, pm.old_code, pm.new_code),
       upp.trust_fiscal_title,
       now(),
       upp.package_name
from user_product_periods upp
         join product_map pm on pm.old_id = upp.user_product_id;

-- и для 10 ТБ меняем trust_fiscal_title
update user_product_periods
set trust_fiscal_title = replace(trust_fiscal_title, '5 ТБ', '10 ТБ')
where code like '%premium10000%';

-- копируем цены
with prices as
         (select code, period, price, discount, original_price
          from (
                   values ('mail_pro_b2c_standard100_v20210525', 'month', 69, null::numeric, null::numeric),
                          ('mail_pro_b2c_standard100_v20210525', 'year', 690, null, null),

                          ('mail_pro_b2c_premium1000_v20210525', 'month', 199, null, null),
                          ('mail_pro_b2c_premium1000_v20210525', 'year', 1990, null, null),

                          ('mail_pro_b2c_premium3000_v20210525', 'month', 409, null, null),
                          ('mail_pro_b2c_premium3000_v20210525', 'year', 4090, null, null),

                          ('mail_pro_b2c_premium5000_v20210525', 'month', 619, null, null),
                          ('mail_pro_b2c_premium5000_v20210525', 'year', 6190, null, null),

                          ('mail_pro_b2c_premium10000_v20210525', 'month', 999, null, null),
                          ('mail_pro_b2c_premium10000_v20210525', 'year', 9990, null, null),

                          -- discount
                          ('mail_pro_b2c_standard100_discount20_v20210525', 'month', 55, 20, 69),
                          ('mail_pro_b2c_standard100_discount20_v20210525', 'year', 552, 20, 690),

                          ('mail_pro_b2c_premium1000_discount20_v20210525', 'month', 159, 20, 199),
                          ('mail_pro_b2c_premium1000_discount20_v20210525', 'year', 1592, 20, 1990),

                          ('mail_pro_b2c_premium3000_discount20_v20210525', 'month', 327, 20, 409),
                          ('mail_pro_b2c_premium3000_discount20_v20210525', 'year', 3272, 20, 4090),

                          ('mail_pro_b2c_premium5000_discount20_v20210525', 'month', 495, 20, 619),
                          ('mail_pro_b2c_premium5000_discount20_v20210525', 'year', 4952, 20, 6190),

                          ('mail_pro_b2c_premium10000_discount20_v20210525', 'month', 799, 20, 999),
                          ('mail_pro_b2c_premium10000_discount20_v20210525', 'year', 7992, 20, 9990)
               ) s(code, period, price, discount, original_price))
insert
into user_product_prices (created_at, region_id, price, currency, display_discount_percent, display_original_price,
                          user_product_period_id)

select now(),
       upp.region_id,
       pr.price,
       upp.currency,
       pr.discount,
       pr.original_price,
       newp.id
from user_product_prices upp
         join user_product_periods p on upp.user_product_period_id = p.id
         join product_map pm on pm.old_id = p.user_product_id
         join user_product_periods newp on newp.user_product_id = pm.new_id
         join prices pr on pr.code = pm.new_code and pr.period = newp.period;

insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
    (
        with order_num as
                 (
                     select code, order_num
                     from (
                              values ('%standard100\_%', 1),
                                     ('%premium1000\_%', 2),
                                     ('%premium3000\_%', 3),
                                     ('%premium5000\_%', 4),
                                     ('%premium10000\_%', 5)
                          ) s(code, order_num)
                 )
        select pl.id, pm.new_id, o.order_num
        from product_map pm
                 join order_num o on pm.new_code like o.code,
             product_sets ps
                 join product_lines pl on ps.id = pl.product_set_id
        where ps.key = 'mail_pro_b2c'
          and pl.order_num = 1
          and pm.new_code not like '%discount%'

        union all

        select pl.id, pm.new_id, o.order_num
        from product_map pm
                 join order_num o on pm.new_code like o.code,
             product_sets ps
                 join product_lines pl on ps.id = pl.product_set_id
        where ps.key = 'mail_pro_b2c'
          and pl.order_num = 1001
          and pm.new_code like '%discount%'
    );

-- добавляем скидочкую линейку к текущим промо
insert into promo_product_lines
select pt.id, pl.id
from promo_templates pt,
     product_sets ps
         join product_lines pl on ps.id = pl.product_set_id
where ps.key = 'mail_pro_b2c'
  and pl.order_num = 1001;

drop table product_map;
