/* pgmigrate-encoding: utf-8 */

-- добавляем в дефолтную линейку стандарт с триалом
insert into group_products_to_product_lines (product_line_id, group_product_id, order_num)
select pl.id, gp.id, 1
from product_lines pl
         join product_sets ps on pl.product_set_id = ps.id,
     group_products gp
where ps.key = 'mail_pro_b2b'
  and pl.selector_bean_el = 'productLineSelectorFactory.availableSelector()'
  and gp.code = 'org_mail_pro_standard100_trial30';

-- дропаем лишние продукты из груповых линеек
delete
from group_products_to_product_lines gptpl
where group_product_id not in (
    select id
    from group_products
    where code in ('org_mail_pro_premium1000',
                   'org_mail_pro_premium3000',
                   'org_mail_pro_standard100_trial30',
                   'org_mail_pro_edu_standard100',
                   'org_mail_pro_edu_premium1000',
                   'org_mail_pro_edu_premium3000'
        )
);

-- дропаем лишнюю линейку
delete
from group_products_to_product_lines
where product_line_id = (select pl.id
                         from product_lines pl
                                  join product_sets ps on pl.product_set_id = ps.id
                         where ps.key = 'mail_pro_b2b'
                           and selector_bean_el =
                               'productLineSelectorFactory.availableFromSelector("2021-03-01", productLineSelectorFactory.availableSelector())');

delete
from product_lines
where id = (select pl.id
            from product_lines pl
                     join product_sets ps on pl.product_set_id = ps.id
            where ps.key = 'mail_pro_b2b'
              and selector_bean_el =
                  'productLineSelectorFactory.availableFromSelector("2021-03-01", productLineSelectorFactory.availableSelector())');

update product_lines
set order_num = 2
where id = (select pl.id
            from product_lines pl
                     join product_sets ps on pl.product_set_id = ps.id
            where ps.key = 'mail_pro_b2b'
              and selector_bean_el = 'productLineSelectorFactory.availableSelector()')
