/* pgmigrate-encoding: utf-8 */

-- двигаем порядок линеек вниз с учетом 2х новых
update product_lines pl
set order_num = order_num + 1
where id in (
    select distinct pl.id
    from product_sets ps
             join product_lines pl on ps.id = pl.product_set_id
    where ps.key = 'mail_pro_b2c'
);

-- добавляем новые линейки
-- дефолтная
insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1,
        'productLineSelectorFactory.availableSelector()');

-- скидочная
insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1001,
        'productLineSelectorFactory.availableSelector()');

-- создаем временную табличку для копирования продуктов
create table product_map
(
    old_id   uuid,
    old_code text,
    new_id   uuid,
    new_code text
);

insert into product_map (old_id, old_code, new_id, new_code)
select distinct up.id                                        as old_id,
                up.code                                      as old_code,
                null::uuid                                   as new_id,
                replace(up.code, '_v20210525', '_v20210610') as new_code
from user_products up
where up.code like '%_v20210525';

-- копируем продукты
insert
into user_products(code, created_at, updated_at, title_tanker_key_id, is_best_offer, product_owner_id,
                   available_from, billing_type, allow_auto_prolong, trust_subs_retry_charging_limit,
                   trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id,
                   trial_definition_id)
select distinct pm.new_code,
                now(),
                now(),
                up.title_tanker_key_id,
                up.is_best_offer,
                up.product_owner_id,
                up.available_from,
                up.billing_type,
                up.allow_auto_prolong,
                up.trust_subs_retry_charging_limit,
                up.trust_subs_retry_charging_delay,
                up.trust_subs_grace_period,
                up.singleton,
                up.trust_service_id,
                up.trial_definition_id
from user_products up
         join product_map pm on pm.old_id = up.id;

-- обновляем айди продуктов в мапе
update product_map
set new_id = (select id from user_products up where up.code = new_code);

-- копируем фичи продуков
insert into product_features (user_product_id, feature_id, amount, created_at, description_tanker_key_id,
                              group_tanker_key_id,
                              value_tanker_key_id, enabled, order_num, code)
select pm.new_id,
       feature_id,
       amount,
       now(),
       description_tanker_key_id,
       group_tanker_key_id,
       value_tanker_key_id,
       enabled,
       order_num,
       code
from product_features pf
         join product_map pm on pm.old_id = pf.user_product_id;

-- копируем user_product_periods
insert
into user_product_periods (user_product_id, period, code, trust_fiscal_title, created_at, package_name)
select pm.new_id,
       upp.period,
       replace(upp.code, pm.old_code, pm.new_code),
       upp.trust_fiscal_title,
       now(),
       upp.package_name
from user_product_periods upp
         join product_map pm on pm.old_id = upp.user_product_id;

-- копируем цены
with prices as
         (select code, period, price, discount, original_price
          from (
                   values ('mail_pro_b2c_standard100_v20210610', 'month', 69, null::numeric, null::numeric),
                          ('mail_pro_b2c_standard100_v20210610', 'year', 499, null, null),

                          ('mail_pro_b2c_premium1000_v20210610', 'month', 199, null, null),
                          ('mail_pro_b2c_premium1000_v20210610', 'year', 1399, null, null),

                          ('mail_pro_b2c_premium3000_v20210610', 'month', 409, null, null),
                          ('mail_pro_b2c_premium3000_v20210610', 'year', 2899, null, null),

                          ('mail_pro_b2c_premium5000_v20210610', 'month', 619, null, null),
                          ('mail_pro_b2c_premium5000_v20210610', 'year', 4333, null, null),

                          ('mail_pro_b2c_premium10000_v20210610', 'month', 999, null, null),
                          ('mail_pro_b2c_premium10000_v20210610', 'year', 6999, null, null),

                          -- discount
                          ('mail_pro_b2c_standard100_discount20_v20210610', 'month', 55, 20, 69),
                          ('mail_pro_b2c_standard100_discount20_v20210610', 'year', 399, 20, 499),

                          ('mail_pro_b2c_premium1000_discount20_v20210610', 'month', 159, 20, 199),
                          ('mail_pro_b2c_premium1000_discount20_v20210610', 'year', 1119, 20, 1399),

                          ('mail_pro_b2c_premium3000_discount20_v20210610', 'month', 327, 20, 409),
                          ('mail_pro_b2c_premium3000_discount20_v20210610', 'year', 2319, 20, 2899),

                          ('mail_pro_b2c_premium5000_discount20_v20210610', 'month', 495, 20, 619),
                          ('mail_pro_b2c_premium5000_discount20_v20210610', 'year', 3466, 20, 4333),

                          ('mail_pro_b2c_premium10000_discount20_v20210610', 'month', 799, 20, 999),
                          ('mail_pro_b2c_premium10000_discount20_v20210610', 'year', 5599, 20, 6999)
               ) s(code, period, price, discount, original_price))
insert
into user_product_prices (created_at, region_id, price, currency, display_discount_percent, display_original_price,
                          user_product_period_id)

select now(),
       upp.region_id,
       pr.price,
       upp.currency,
       pr.discount,
       pr.original_price,
       newp.id
from user_product_prices upp
         join user_product_periods p on upp.user_product_period_id = p.id
         join product_map pm on pm.old_id = p.user_product_id
         join user_product_periods newp on newp.user_product_id = pm.new_id
         join prices pr on pr.code = pm.new_code and pr.period = newp.period;

insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
    (
        with order_num as
                 (
                     select code, order_num
                     from (
                              values ('%standard100\_%', 1),
                                     ('%premium1000\_%', 2),
                                     ('%premium3000\_%', 3),
                                     ('%premium5000\_%', 4),
                                     ('%premium10000\_%', 5)
                          ) s(code, order_num)
                 )
        select pl.id, pm.new_id, o.order_num
        from product_map pm
                 join order_num o on pm.new_code like o.code,
             product_sets ps
                 join product_lines pl on ps.id = pl.product_set_id
        where ps.key = 'mail_pro_b2c'
          and pl.order_num = 1
          and pm.new_code not like '%discount%'

        union all

        select pl.id, pm.new_id, o.order_num
        from product_map pm
                 join order_num o on pm.new_code like o.code,
             product_sets ps
                 join product_lines pl on ps.id = pl.product_set_id
        where ps.key = 'mail_pro_b2c'
          and pl.order_num = 1001
          and pm.new_code like '%discount%'
    );

-- добавляем скидочкую линейку к текущим промо
insert into promo_product_lines
select pt.id, pl.id
from promo_templates pt,
     product_sets ps
         join product_lines pl on ps.id = pl.product_set_id
where ps.key = 'mail_pro_b2c'
  and pl.order_num = 1001;

drop table product_map;

-- создаем временную табличку для удаления неактуальных линеек
create table obsolete_lines
(
    id uuid
);
insert into obsolete_lines
select pl.id
from product_sets ps
         join product_lines pl on ps.id = pl.product_set_id
where ps.key = 'mail_pro_b2c'
  and pl.order_num > 1
  and pl.order_num != 1001;


-- добавляем продукты из не актуальных линеек, которые более нигде не используются, в бакет явно
with actual_products as
         (
             select up.id
             from product_lines pl
                      join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
                      join user_products up on uptpl.user_product_id = up.id
             where pl.id not in (select id from obsolete_lines)
             order by pl.order_num
         ),
     not_actual_products as
         (
             select up.id
             from product_lines pl
                      join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
                      join user_products up on uptpl.user_product_id = up.id
             where pl.id in (select id from obsolete_lines)
             order by pl.order_num)
insert
into user_product_buckets (code, created_at, user_product_id, product_line_id, product_set_id)
select distinct 'mail360', now(), nap.id, null::uuid, null::uuid
from not_actual_products nap
         left join actual_products ap
                   on nap.id = ap.id
where ap.id is null;


-- удаляем продукты из старых линеек
ALTER TABLE public.user_products_to_product_lines
    DISABLE TRIGGER delete_product_from_product_line_trigger;

delete
from user_products_to_product_lines uptpl
where uptpl.product_line_id in (select id from obsolete_lines);

ALTER TABLE public.user_products_to_product_lines
    ENABLE TRIGGER delete_product_from_product_line_trigger;

-- удаляем старые линейки
ALTER TABLE public.product_lines
    DISABLE TRIGGER delete_product_line_trigger;

delete
from product_lines pl
where pl.id in (select id from obsolete_lines);

ALTER TABLE public.product_lines
    DISABLE TRIGGER delete_product_line_trigger;

-- чистим бакеты - удаляем продукты, добавленные явно, если они уже есть в бакете из за product_set
delete
from user_product_buckets
where id in (
    with product_set_products as (
        select distinct up.id
        from user_product_buckets upb
                 join product_sets ps on ps.id = upb.product_set_id
                 join product_lines pl on ps.id = pl.product_set_id
                 join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
                 join user_products up on uptpl.user_product_id = up.id
    )
    select upb.user_product_id
    from user_product_buckets upb
             join product_set_products psp on psp.id = upb.user_product_id
    where upb.user_product_id is not null
);

--удалим истекшую акцию заодно
delete
from public.promo_templates
where code = 'may_holidays_20percent_discount';
