/* pgmigrate-encoding: utf-8 */
select copy_products('%standard100_inapp_google', '_inapp_google', '_introductory_inapp_google');
select copy_products('%premium%_inapp_google', '_inapp_google', '_introductory_inapp_google');

-- добавим триалы
with trial as
         (
             insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price,
                                            single_usage_comparison_key)
                 values (now(), 'constant_period', null, 30, 'day', 0, 'mail_pro_b2c_android_trial_key') returning id
         )
update user_products up
set trial_definition_id = (select id from trial)
where up.code like '%_introductory_inapp_google';


-- добавляем новую скидочную линейку и добавляем в нее созданные продукты
with promo_line_id as
         (
             insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
                 values ((select id from product_sets where key = 'inapp_android'), now(), 1001,
                         'productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_android_trial_key", productLineSelectorFactory.availableSelector())')
                 returning id
         ),
     order_num as
         (
             select code, order_num
             from (
                      values ('%standard100%', 1),
                             ('%premium1000%', 2),
                             ('%premium3000%', 3),
                             ('%premium5000%', 4)
                  ) s(code, order_num)
         )
insert
into user_products_to_product_lines (product_line_id, user_product_id, order_num)
    (
        select promo_line_id.id, up.id, order_num
        from promo_line_id,
             user_products up
                 join order_num o on up.code like o.code
        where up.code like '%_introductory_inapp_google'
    );

-- добавляем тестовый ключ
with test_key as
         (
             insert into tanker_keys (created_at, project, key_set, key)
                 values (now(), 'disk-ps-billing', 'for_tests', 'test_key') returning id
         )
-- создадим акцию для тестирования
insert
into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, mobile_background_url, created_at)
values ('android_introductory_test', 'тестируем интро', (select id from test_key), now(), null,
        'per_user'::promo_application_area, 'one_time'::promo_application_type, null, null, null,
        'https://s245vla.storage.yandex.net/rdisk/0cd5ef9f119a979c060cd7acc7c3b217bc0f2c1972d34ce6b15c23ed3563712a/60dddf6d/slzk1JGSBd76MEqwMRlXQKNI3i3QMHW23pH7mLM_nn5Mf5IREUGuvtyCqKO_8z7AulAQa5qJdEAY6xM6csJM8Q==?uid=0&filename=this-is-fine.png&disposition=inline&hash=&limit=0&content_type=image%2Fpng&owner_uid=0&fsize=652988&hid=7d3d4d061bef2e2e1efa9e90a899c70c&media_type=image&tknv=v2&etag=5ecef0b30f714c30fc325dc9e06d96f1&rtoken=5ioLMaxdiTED&force_default=no&ycrid=na-9dd54eadd21436aa5b865cbc5d798911-downloader19e&ts=5c6118274f540&s=d63c8b26555d7cb5091049cccdcc5ea76470c43cc5dc70cfa3f49c0f0a162b36&pb=U2FsdGVkX1-71aODy0vdro08hrIqKewK56AZb0xkX8c9jT9K4KDds6uK3bw8dJ34UG_CXg1g4pXO4IsuHgoq8kDDxHKICE35F_cW8g1E5D4',
        now());

-- добавим в акцию созданную линейку
insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = 'android_introductory_test'),
        (select l.id
         from product_lines l
                  join product_sets ps on l.product_set_id = ps.id
         where ps.key = 'inapp_android'
           and l.order_num = 1001));

-- и существующие линейки эпла - для них нужна тоьлко дата
insert into promo_product_lines(promo_template_id, product_line_id)
select (select id from promo_templates where code = 'android_introductory_test'), pl.Id
from product_sets ps
         join product_lines pl on ps.id = pl.product_set_id
where ps.key in ('inapp_ios_mail', 'inapp_ios_disk')
