/* pgmigrate-encoding: utf-8 */

-- убираем безумный каскандный дроп заказов
alter table orders
    drop constraint fk_user_product_prices;

-- заменяем на обычный FK
alter table orders
    add constraint fk_user_product_prices
        foreign key (user_product_price_id) references user_product_prices;

-- создаем табличку для бекапа удаленных данных

create table user_product_prices_backup
(
    id                       uuid,
    created_at               timestamp,
    region_id                text,
    price                    numeric,
    currency                 text,
    display_discount_percent numeric,
    display_original_price   numeric,
    user_product_period_id   uuid
);


-- собираем цены для удаления
with problem_codes as --берем коды периодов, которые содержат больше одной цены в рамках региона
         (
             select upp.code, pr.region_id
             from user_products up
                      join user_product_periods upp on up.id = upp.user_product_id
                      join user_product_prices pr on upp.id = pr.user_product_period_id
             group by upp.code, pr.region_id
             having count(1) > 1
         ),
     using_prices as --смотрим какие цены реально используются (на проде глянул-везде одна цена, факапа нет)
         (
             select distinct pr.*
             from user_services us
                      join user_product_prices pr on us.user_product_price_id = pr.id
                      join user_product_periods upp on pr.user_product_period_id = upp.id
                      join problem_codes pc on upp.code = pc.code and pr.region_id = pc.region_id

             union

             select distinct pr.*
             from orders o
                      join user_product_prices pr on o.user_product_price_id = pr.id
                      join user_product_periods upp on pr.user_product_period_id = upp.id
                      join problem_codes pc on upp.code = pc.code and pr.region_id = pc.region_id
         ),
     not_used_prices as -- берем периоды цен, которые используются и смотрим какие другие цены у этих периодов есть
         (
             select distinct pr.*
             from using_prices up
                      join user_product_prices pr
                           on up.region_id = pr.region_id
                               and up.user_product_period_id = pr.user_product_period_id
                               and pr.id != up.id
         ),
-- на случай, если цены не использовались, но дублирование присутствует, например в тестинге и прейстейбле,
-- то оставим только одно значение
     first_period_and_region_prices as -- берем первую попавшуюся цену в регионе для периода - она останется.
         (
             select distinct first_value(pr.id) over (PARTITION BY upp.code, pr.region_id) as id
             from user_product_prices pr
                      join user_product_periods upp on pr.user_product_period_id = upp.id
                      join problem_codes pc on upp.code = pc.code and pr.region_id = pc.region_id
             where pr.id not in (select id from not_used_prices) -- эти отсеиваем, они и так будут удалены
         )

insert
into user_product_prices_backup
    (select id,
            created_at,
            region_id,
            price,
            currency,
            display_discount_percent,
            display_original_price,
            user_product_period_id
     from not_used_prices -- дропаем неиспользуемые
     union
     select pr.id,
            pr.created_at,
            pr.region_id,
            pr.price,
            pr.currency,
            pr.display_discount_percent,
            pr.display_original_price,
            pr.user_product_period_id
     from user_product_prices pr -- дропаем проблемные цены, которые не ходят в выборку first_period_and_region_prices
              join user_product_periods upp on pr.user_product_period_id = upp.id
              join problem_codes pc on upp.code = pc.code and pr.region_id = pc.region_id
     where pr.id not in (select id from first_period_and_region_prices)
    );

-- дропаем те цены, которые мы забекапили
delete
from user_product_prices
where id in (select id from user_product_prices_backup);

-- фиксируем возможность иметь одну цену в регионе
create unique index user_product_prices_unique on user_product_prices (user_product_period_id, region_id);

-- создаем скрипт восстановления на случай внезапного факапа
-- insert into user_product_prices
-- select * from user_product_prices_backup;

-- обновлям цены у интродактари продуктов, потому что там цены разъехались хуже, чем везде, но эти продукты пока не в проде и цены там ни на что не влияют. Убедимся что оставшиеся цены правильные


update user_product_prices
set price = 69
where id = (select pr.id
            from user_product_periods upp
                     join user_product_prices pr on upp.id = pr.user_product_period_id
            where code = 'mail_pro_b2c_standard100_introductory_inapp_google_month');
update user_product_prices
set price = 499
where id = (select pr.id
            from user_product_periods upp
                     join user_product_prices pr on upp.id = pr.user_product_period_id
            where code = 'mail_pro_b2c_standard100_introductory_inapp_google_year');


update user_product_prices
set price = 199
where id = (select pr.id
            from user_product_periods upp
                     join user_product_prices pr on upp.id = pr.user_product_period_id
            where code = 'mail_pro_b2c_premium1000_introductory_inapp_google_month');
update user_product_prices
set price = 1390
where id = (select pr.id
            from user_product_periods upp
                     join user_product_prices pr on upp.id = pr.user_product_period_id
            where code = 'mail_pro_b2c_premium1000_introductory_inapp_google_year');


update user_product_prices
set price = 399
where id = (select pr.id
            from user_product_periods upp
                     join user_product_prices pr on upp.id = pr.user_product_period_id
            where code = 'mail_pro_b2c_premium3000_introductory_inapp_google_month');
update user_product_prices
set price = 2890
where id = (select pr.id
            from user_product_periods upp
                     join user_product_prices pr on upp.id = pr.user_product_period_id
            where code = 'mail_pro_b2c_premium3000_introductory_inapp_google_year');


update user_product_prices
set price = 599
where id = (select pr.id
            from user_product_periods upp
                     join user_product_prices pr on upp.id = pr.user_product_period_id
            where code = 'mail_pro_b2c_premium5000_introductory_inapp_google_month');
update user_product_prices
set price = 4390
where id = (select pr.id
            from user_product_periods upp
                     join user_product_prices pr on upp.id = pr.user_product_period_id
            where code = 'mail_pro_b2c_premium5000_introductory_inapp_google_year');

