/* pgmigrate-encoding: utf-8 */

select copy_products('%00_v20210610', '_v20210610', '_trial30_v20210610');

-- добавим триалы
update user_products up
set trial_definition_id = (select id
                           from trial_definitions
                           where single_usage_comparison_key = 'mail_pro_b2c_trial_key'
                             and duration = 30)
where up.code like '%_trial30_v20210610';

-- двигаем линейки
update product_lines
set order_num = order_num + 1
where product_set_id in (select id from product_sets where key = 'mail_pro_b2c')
  and order_num >= 1001;

-- добавляем новую скидочную линейку и добавляем в нее созданные продукты
with promo_line_id as
         (
             insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
                 values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1001,
                         'productLineSelectorFactory.onlyIfTrialNotUsed("mail_pro_b2c_trial_key", productLineSelectorFactory.availableSelector())')
                 returning id
         ),
     order_num as
         (
             select code, order_num
             from (
                      values ('%standard100\_%', 1),
                             ('%premium1000\_%', 2),
                             ('%premium3000\_%', 3),
                             ('%premium5000\_%', 4),
                             ('%premium10000\_%', 5)
                  ) s(code, order_num)
         )
insert
into user_products_to_product_lines (product_line_id, user_product_id, order_num)
    (
        select promo_line_id.id, up.id, order_num
        from promo_line_id,
             user_products up
                 join order_num o on up.code like o.code
        where up.code like '%_trial30_v20210610'
    );

insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('july_trial_promo', 'Триалы на все продукты в июле', null, '2021-08-02',
        '2021-08-05',
        'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = 'july_trial_promo'),
        (select l.id
         from product_lines l
                  join product_sets ps on l.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and l.order_num = 1001));
