/* pgmigrate-encoding: utf-8 */
create table distribution_platform_transactions
(
    id              UUID      NOT NULL DEFAULT uuid_generate_v4() primary key,
    calc_month      date      not null,
    group_id        uuid      not null REFERENCES groups,
    paid_user_count numeric   not null,
    amount          decimal   not null,
    clid            text      not null,
    currency        text      not null,
    act_id          text      not null,
    created_at      TIMESTAMP NOT NULL
);

comment on column distribution_platform_transactions.paid_user_count is
    'количество платных пользователей за месяц. считаем как сумму количества платных секунд пользователей в этой организации, поделенных на кол-во секунд в месяце';
comment on column distribution_platform_transactions.amount is
    'все деньги, которые получили от организациям в рамках акта. Процентами отчислений занимается платформа дистрибуции';
comment on column distribution_platform_transactions.act_id is
    'id акта баланса, по которому делали расчет';
create unique index distribution_platform_transactions_uk on distribution_platform_transactions (group_id, act_id);
create index distribution_platform_transactions_groups_fki on distribution_platform_transactions (group_id);
