/* pgmigrate-encoding: utf-8 */

CREATE OR REPLACE FUNCTION copy_products(where_clause text, code_replace_from text, code_replace_to text)
    RETURNS int
    LANGUAGE plpgsql AS
$function$
BEGIN
    create table product_map
    (
        old_id   uuid,
        old_code text,
        new_id   uuid,
        new_code text
    );

    insert into product_map (old_id, old_code, new_id, new_code)
    select distinct up.id                                                as old_id,
                    up.code                                              as old_code,
                    null::uuid                                           as new_id,
                    replace(up.code, code_replace_from, code_replace_to) as new_code
    from user_products up
    where up.code like where_clause;

-- копируем продукты
    insert
    into user_products(code, code_family, created_at, updated_at, title_tanker_key_id, is_best_offer, product_owner_id,
                       available_from, billing_type, allow_auto_prolong, trust_subs_retry_charging_limit,
                       trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id,
                       trial_definition_id)
    select distinct pm.new_code,
                    up.code_family,
                    now(),
                    now(),
                    up.title_tanker_key_id,
                    up.is_best_offer,
                    up.product_owner_id,
                    up.available_from,
                    up.billing_type,
                    up.allow_auto_prolong,
                    up.trust_subs_retry_charging_limit,
                    up.trust_subs_retry_charging_delay,
                    up.trust_subs_grace_period,
                    up.singleton,
                    up.trust_service_id,
                    up.trial_definition_id
    from user_products up
             join product_map pm on pm.old_id = up.id;

    -- обновляем айди продуктов в мапе
-- noinspection SqlWithoutWhere
    update product_map
    set new_id = (select id from user_products up where up.code = new_code);

-- копируем фичи продуков
    insert into product_features (user_product_id, feature_id, amount, created_at, description_tanker_key_id,
                                  group_tanker_key_id,
                                  value_tanker_key_id, enabled, order_num, code)
    select pm.new_id,
           feature_id,
           amount,
           now(),
           description_tanker_key_id,
           group_tanker_key_id,
           value_tanker_key_id,
           enabled,
           order_num,
           code
    from product_features pf
             join product_map pm on pm.old_id = pf.user_product_id;

-- копируем периоды
    insert
    into user_product_periods (user_product_id, period, code, trust_fiscal_title, created_at, package_name)
    select pm.new_id,
           upp.period,
           replace(upp.code, pm.old_code, pm.new_code),
           upp.trust_fiscal_title,
           now(),
           upp.package_name
    from user_product_periods upp
             join product_map pm on pm.old_id = upp.user_product_id;

-- копируем цены
    insert
    into user_product_prices (created_at, region_id, price, currency, display_discount_percent, display_original_price,
                              user_product_period_id)

    select now(),
           upp.region_id,
           upp.price,
           upp.currency,
           upp.display_discount_percent,
           upp.display_original_price,
           newp.id
    from user_product_prices upp
             join user_product_periods p on upp.user_product_period_id = p.id
             join product_map pm on pm.old_id = p.user_product_id
             join user_product_periods newp on newp.user_product_id = pm.new_id and newp.period = p.period;

    drop table product_map;
    RETURN 0;
END
$function$;
