/* pgmigrate-encoding: utf-8 */
select copy_products('mail_pro_b2c_premium10000_v20210610', 'premium10000_v20210610',
                     'premium25000_v20210813');
select copy_products('mail_pro_b2c_premium10000_v20210610', 'premium10000_v20210610',
                     'premium50000_v20210813');

select copy_products('mail_pro_b2c_premium10000_v20210610', 'premium10000_v20210610',
                     'premium25000_discount20_v20210813');
select copy_products('mail_pro_b2c_premium10000_v20210610', 'premium10000_v20210610',
                     'premium50000_discount20_v20210813');

select copy_products('mail_pro_b2c_premium10000_v20210610', 'premium10000_v20210610',
                     'premium25000_discount30_v20210813');
select copy_products('mail_pro_b2c_premium10000_v20210610', 'premium10000_v20210610',
                     'premium50000_discount30_v20210813');

select change_price('mail_pro_b2c_premium25000_v20210813', 'month', 2490, null, null);
select change_price('mail_pro_b2c_premium25000_v20210813', 'year', 17490, null, null);
select change_price('mail_pro_b2c_premium25000_discount20_v20210813', 'month', 1992, 20, 2490);
select change_price('mail_pro_b2c_premium25000_discount20_v20210813', 'year', 13992, 20, 17490);
select change_price('mail_pro_b2c_premium25000_discount30_v20210813', 'month', 1743, 30, 2490);
select change_price('mail_pro_b2c_premium25000_discount30_v20210813', 'year', 12243, 30, 17490);

select change_price('mail_pro_b2c_premium50000_v20210813', 'month', 4990, null, null);
select change_price('mail_pro_b2c_premium50000_v20210813', 'year', 34990, null, null);
select change_price('mail_pro_b2c_premium50000_discount20_v20210813', 'month', 3992, 20, 4990);
select change_price('mail_pro_b2c_premium50000_discount20_v20210813', 'year', 27992, 20, 34990);
select change_price('mail_pro_b2c_premium50000_discount30_v20210813', 'month', 3493, 30, 4990);
select change_price('mail_pro_b2c_premium50000_discount30_v20210813', 'year', 24493, 30, 34990);

-- меняем танкеры объема
with tanker as (insert into tanker_keys (created_at, project, key_set, key)
    values (now(), 'disk-ps-billing', 'features', 'mail_pro_add_25tb') returning id)
update product_features
set amount              = 27487790694400,
    value_tanker_key_id = (select id from tanker)
where user_product_id in (select id
                          from user_products pm
                          where code like 'mail_pro_b2c_premium25000%')
  and amount > 1;


with tanker as (insert into tanker_keys (created_at, project, key_set, key)
    values (now(), 'disk-ps-billing', 'features', 'mail_pro_add_50tb') returning id)
update product_features
set amount              = 54975581388800,
    value_tanker_key_id = (select id from tanker)
where user_product_id in (select id
                          from user_products pm
                          where code like 'mail_pro_b2c_premium50000%')
  and amount > 1;

-- добавляем в линейки, в которых участвует текущий продукт
with pairs as
         (select l, r, shift
          from (
                   values ('mail_pro_b2c_premium10000_v20210610',
                           'mail_pro_b2c_premium25000_v20210813', 1),
                          ('mail_pro_b2c_premium10000_discount20_v20210610',
                           'mail_pro_b2c_premium25000_discount20_v20210813', 1),
                          ('mail_pro_b2c_premium10000_discount30_v20210610',
                           'mail_pro_b2c_premium25000_discount30_v20210813', 1),
                          ('mail_pro_b2c_premium10000_v20210610',
                           'mail_pro_b2c_premium50000_v20210813', 2),
                          ('mail_pro_b2c_premium10000_discount20_v20210610',
                           'mail_pro_b2c_premium50000_discount20_v20210813', 2),
                          ('mail_pro_b2c_premium10000_discount30_v20210610',
                           'mail_pro_b2c_premium50000_discount30_v20210813', 2)
               ) s(l, r, shift))
insert
into user_products_to_product_lines (product_line_id, user_product_id, order_num)
select uptpl.product_line_id, nup.id, uptpl.order_num + p.shift
from pairs p
         join user_products up on up.code = p.l
         join user_products_to_product_lines uptpl on up.id = uptpl.user_product_id
         join user_products nup on nup.code = p.r;


-- обновляем название продукта
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_premium25000'),
       (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_premium50000');

update user_products
set title_tanker_key_id = (select id
                           from tanker_keys
                           where project = 'disk-ps-billing'
                             and key_set = 'products'
                             and key = 'mail_pro_b2c_premium25000')
where code like 'mail_pro_b2c_premium25000%';

update user_products
set title_tanker_key_id = (select id
                           from tanker_keys
                           where project = 'disk-ps-billing'
                             and key_set = 'products'
                             and key = 'mail_pro_b2c_premium50000')
where code like 'mail_pro_b2c_premium50000%';
