/* pgmigrate-encoding: utf-8 */

select copy_products('%discount20_v20210610', 'discount20', 'discount30');

select change_price('mail_pro_b2c_standard100_discount30_v20210610', 'month', 48, 30, 69);
select change_price('mail_pro_b2c_premium1000_discount30_v20210610', 'month', 139, 30, 199);
select change_price('mail_pro_b2c_premium3000_discount30_v20210610', 'month', 286, 30, 409);
select change_price('mail_pro_b2c_premium5000_discount30_v20210610', 'month', 433, 30, 619);
select change_price('mail_pro_b2c_premium10000_discount30_v20210610', 'month', 699, 30, 999);

select change_price('mail_pro_b2c_standard100_discount30_v20210610', 'year', 353, 30, 499);
select change_price('mail_pro_b2c_premium1000_discount30_v20210610', 'year', 983, 30, 1399);
select change_price('mail_pro_b2c_premium3000_discount30_v20210610', 'year', 2033, 30, 2899);
select change_price('mail_pro_b2c_premium5000_discount30_v20210610', 'year', 3041, 30, 4333);
select change_price('mail_pro_b2c_premium10000_discount30_v20210610', 'year', 4906, 30, 6999);

update product_lines
set order_num = order_num + 1
where order_num >= 1002
  and product_set_id = (select id from product_sets where key = 'mail_pro_b2c');

-- добавляем новую скидочную линейку и добавляем в нее созданные продукты
with promo_line_id as
         (
             insert into product_lines (product_set_id, created_at, order_num, selector_bean_el)
                 values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1002,
                         'productLineSelectorFactory.availableSelector()')
                 returning id
         ),
     order_num as
         (
             select code, order_num
             from (
                      values ('%standard100\_%', 1),
                             ('%premium1000\_%', 2),
                             ('%premium3000\_%', 3),
                             ('%premium5000\_%', 4),
                             ('%premium10000\_%', 5),
                             ('%premium25000\_%', 6),
                             ('%premium50000\_%', 7)
                  ) s(code, order_num)
         )
insert
into user_products_to_product_lines (product_line_id, user_product_id, order_num)
    (
        select promo_line_id.id, up.id, order_num
        from promo_line_id,
             user_products up
                 join order_num o on up.code like o.code
        where up.code like '%discount30%'
    );


insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('august_end_promo', '30% на все продукты в августе', null, '2021-08-30', '2021-09-03',
        'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = 'august_end_promo'),
        (select l.id
         from product_lines l
                  join product_sets ps on l.product_set_id = ps.id
         where ps.key = 'mail_pro_b2c'
           and l.order_num = 1002));
