/* pgmigrate-encoding: utf-8 */

-- CHEMODAN-79231
--  ro_no_b2c_tariff_promo
insert into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
                     activation_url_http_method, activation_url_template, set_amount_url_http_method,
                     set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
                     call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
                     set_amount_body_template, deactivation_body_template, activation_content_type,
                     deactivation_content_type, set_amount_content_type, error_processor_name)
select 'ro_no_b2c_tariff_promo',
       now(),
       now(),
       f.system_tvm_id,
       f.type,
       'Сокрытие промо b2c подписки',
       f.system_name,
       f.activation_url_http_method,
       f.activation_url_template,
       f.set_amount_url_http_method,
       f.set_amount_url_template,
       f.deactivation_url_http_method,
       f.deactivation_url_template,
       f.call_set_amount_on_activation,
       f.call_set_amount_on_deactivation,
       'ro_no_b2c_tariff_promo=on',
       f.set_amount_body_template,
       'ro_no_b2c_tariff_promo=',
       f.activation_content_type,
       f.deactivation_content_type,
       f.set_amount_content_type,
       f.error_processor_name
from features f
where f.code = 'mail_b2c_domain_enabled';


insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code)
select p.id,
       f.id,
       1,
       now(),
       null, --description_tanker_key_id=null is the crunch for hidden by default feature
       true,
       null,
       null,
       999,
       f.code
from user_products p
         join features f on f.code = 'ro_no_b2c_tariff_promo'
where p.code in (
          select code
          from user_products
          where code like '%b2b%'
            and code != 'b2b_disk_default');

--  ro_no_yandex_jobs
insert into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
                     activation_url_http_method, activation_url_template, set_amount_url_http_method,
                     set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
                     call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
                     set_amount_body_template, deactivation_body_template, activation_content_type,
                     deactivation_content_type, set_amount_content_type, error_processor_name)
select 'ro_no_yandex_jobs',
       now(),
       now(),
       f.system_tvm_id,
       f.type,
       'Сокрытие промо вакансий',
       f.system_name,
       f.activation_url_http_method,
       f.activation_url_template,
       f.set_amount_url_http_method,
       f.set_amount_url_template,
       f.deactivation_url_http_method,
       f.deactivation_url_template,
       f.call_set_amount_on_activation,
       f.call_set_amount_on_deactivation,
       'ro_no_yandex_jobs=on',
       f.set_amount_body_template,
       'ro_no_yandex_jobs=',
       f.activation_content_type,
       f.deactivation_content_type,
       f.set_amount_content_type,
       f.error_processor_name
from features f
where f.code = 'mail_b2c_domain_enabled';


insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code)
select p.id,
       f.id,
       1,
       now(),
       null, --description_tanker_key_id=null is the crunch for hidden by default feature
       true,
       null,
       null,
       999,
       f.code
from user_products p
         join features f on f.code = 'ro_no_yandex_jobs'
where p.code in (
    select code
    from user_products
    where code like '%b2b%'
      and code != 'b2b_disk_default');

update user_services
set status            = 'init',
    updated_at        = now(),
    status_updated_at = now()
where target = 'enabled'
  and user_product_id in
      (
          select id
          from user_products
          where code like '%b2b%'
            and code
    != 'b2b_disk_default');
