/* pgmigrate-encoding: utf-8 */
-- добавляем тестовый ключ
with test_key as
         (
             insert into tanker_keys (created_at, project, key_set, key)
                 values (now(), 'disk-ps-billing', 'promos', 'early_september_mobile_promo_30') returning id
         )
-- создадим акцию для тестирования
insert
into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, mobile_payload, created_at)
values ('september_early_mobile_promo', '-30% для мобильных в начале сентября',
        (select id from test_key),
        '2021-09-06', '2021-09-09',
        'global'::promo_application_area, 'one_time'::promo_application_type, null, null, null,
        null, now());

-- добавим в акцию линейку ios
insert into promo_product_lines(promo_template_id, product_line_id)
select pt.id, l.id
from promo_templates pt,
     product_lines l
         join product_sets ps on l.product_set_id = ps.id
where ps.key in ('inapp_ios_disk', 'inapp_android')
  and l.order_num = 1001
  and pt.code = 'september_early_mobile_promo';
